/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IRecordTypes;


public class RecordTypes implements IRecordTypes 
{
	private String namespace = null;
	private String schemaLocation = null;
	private List<IRecordType> recordType = new ArrayList<IRecordType>(); // 0 or more

	
	/**
	 * set the namespace 
	 * 
	 * @param namespace
	 */
	public void setNamespace(String namespace){
		this.namespace = namespace;
	}
		
	/**
	 * Retrieve the namespace
	 * 
	 * @return namespace
	 */
	public String getNamespace(){
		return namespace;
	}

	
	/**
	 * set the schemaLocation 
	 * 
	 * @param schemaLocation
	 */
	public void setSchemaLocation(String schemaLocation){
		this.schemaLocation = schemaLocation;
	}
		
	/**
	 * Retrieve the schemaLocation
	 * 
	 * @return schemaLocation
	 */
	public String getSchemaLocation(){
		return schemaLocation;
	}

	
	/**
	 * add a recordType
	 * 
	 * @param recordType
	 */
	public void addRecordType(IRecordType recordType){
		this.recordType.add(recordType);
	}
	
	/**
	 * get a collection of recordType
	 * 
	 */
	public IRecordType[] getRecordType(){
		return recordType.toArray(new IRecordType[recordType.size()]);
	}


	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.tagFor(false, null, ServiceMetadataConstants.RECORDTYPES_ELEMENT, false));
		
		if ( namespace != null || schemaLocation != null ){
			if ( namespace != null){
				writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
				CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.NAMESPACE_ATTRIBUTE, namespace );
			}
			
			if ( schemaLocation != null){
				writer.write(ICMDBfServicesConstants.SINGLE_SPACE);
				CMDBfServicesUtil.writeAttribute(writer, ServiceMetadataConstants.SCHEMALOCATION_ATTRIBUTE, schemaLocation );
			}
		}
		writer.write(ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, recordType);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.RECORDTYPES_ELEMENT)+ICMDBfServicesConstants.nl);

	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordTypes other = (RecordTypes) obj;
		if (namespace == null) {
			if (other.namespace != null)
				return false;
		} else if (!namespace.equals(other.namespace))
			return false;
		if (schemaLocation == null) {
			if (other.schemaLocation != null)
				return false;
		} else if (!schemaLocation.equals(other.schemaLocation))
			return false;
		if (recordType == null) {
			if (other.recordType != null)
				return false;
		} else if (!recordType.equals(other.recordType))
			return false;

		return true;
	}
	
}
