/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.ServiceMetadataConstants;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IDialect;
import org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IXpathSupport;


public class XpathSupport implements IXpathSupport 
{
	private List<IDialect> dialects = new ArrayList<IDialect>(); // 0 or more

	
	/**
	 * add a dialect to the xpathSupport
	 * 
	 * @param dialect
	 */
	public void addDialect(IDialect dialect){
		dialects.add(dialect);
	}
	
	/**
	 * get a collection of dialects
	 * 
	 */
	public IDialect[] getDialects(){
		return dialects.toArray(new IDialect[dialects.size()]);
	}

	
	public void toXML(StringWriter writer, int indent) 
	{
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ServiceMetadataConstants.XPATHSUPPORT_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, dialects);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ServiceMetadataConstants.XPATHSUPPORT_ELEMENT)+ICMDBfServicesConstants.nl);
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((dialects == null) ? 0 : dialects.hashCode());
		return result;
	}


	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final XpathSupport other = (XpathSupport) obj;
		if (dialects == null) {
			if (other.dialects != null)
				return false;
		} else if (!dialects.equals(other.dialects))
			return false;

		return true;
	}
	
}
