/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts;

/**
 * Interface that must be implemented in order to create
 * POJOs for service metadata
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IMetadataArtifactFactory {

	/**
	 * Create a new instance of IQueryServiceMetadata representing a <queryServiceMetadata> element
	 * 
	 * @return IQueryServiceMetadata
	 */
	public abstract IQueryServiceMetadata createQueryServiceMetadata();

	/**
	 * Create a new instance of IRegistrationServiceMetadata representing a <registrationServiceMetadata> element
	 * 
	 * @return IRegistrationServiceMetadata
	 */
	public abstract IRegistrationServiceMetadata createRegistrationServiceMetadata();

	/**
	 * Create a new instance of IServiceDescription representing a <serviceDescription> element
	 * 
	 * @return
	 */
	public abstract IServiceDescription createServiceDescription();

	/**
	 * Create a new instance of IQueryCapabilities representing a <queryCapabilities> element
	 * 
	 * @return
	 */
	public abstract IQueryCapabilities createQueryCapabilities();

	/**
	 * Create a new instance of IRelationshipTemplateSupport representing a <relationshipTemplateSupport> element
	 * 
	 * @return
	 */
	public abstract IRelationshipTemplateSupport createRelationshipTemplateSupport();

	/**
	 * Create a new instance of IContentSelectorSupport representing a <contentSelectorSupport> element
	 * 
	 * @return
	 */
	public abstract IContentSelectorSupport createContentSelectorSupport();

	/**
	 * Create a new instance of IRecordConstraintSupport representing a <recordConstraintSupport> element
	 * 
	 * @return
	 */
	public abstract IRecordConstraintSupport createRecordConstraintSupport();

	/**
	 * Create a new instance of IXpathSupport representing a <xpathSupport> element
	 * 
	 * @return
	 */
	public abstract IXpathSupport createXpathSupport();

	/**
	 * Create a new instance of IDialect representing a <dialect> element
	 * 
	 * @return
	 */
	public abstract IDialect createDialect();

	/**
	 * Create a new instance of IPropertyValueOperators representing a <propertyValueOperators> element
	 * 
	 * @return
	 */
	public abstract IPropertyValueOperators createPropertyValueOperators();

	/**
	 * Create a new instance of IRecordTypeList representing a <recordTypeList> element
	 * 
	 * @return
	 */
	public abstract IRecordTypeList createRecordTypeList();

	/**
	 * Create a new instance of IRecordTypes representing a <recordTypes> element
	 * 
	 * @return
	 */
	public abstract IRecordTypes createRecordTypes();

	/**
	 * Create a new instance of IRecordType representing a <recordType> element
	 * 
	 * @return
	 */
	public abstract IRecordType createRecordType();

}