/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.IRootElement;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;


/**
 * Represents a <registrationServiceMetadata> element in XML form
 * 
 * @provisional
 * @author Bill Muldoon
 */
public interface IRegistrationServiceMetadata extends IXMLWritable, IRootElement
{
	/**
	 * set the serviceDescription in the queryServiceMetaData
	 * 
	 * @param serviceDescription
	 */
	public void setServiceDescription(IServiceDescription serviceDescription);
		
	/**
	 * Retrieve a serviceDescription
	 * 
	 * @return IServiceDescription
	 */
	public IServiceDescription getServiceDescription();

	
	/**
	 * set the recordTypeList in the queryServiceMetaData
	 * 
	 * @param recordTypeList
	 */
	public void setRecordTypeList(IRecordTypeList recordTypeList);
		
	/**
	 * Retrieve a recordTypeList
	 * 
	 * @return IRecordTypeList
	 */
	public IRecordTypeList getRecordTypeList();

}
