/*******************************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     CA - initial API and implementation
 *     IBM - provisional API change, removed IRootElement
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.ContentSelectorSupport;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.Dialect;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.PropertyValueOperators;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.QueryCapabilities;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.QueryServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RecordConstraintSupport;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RecordType;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RecordTypeList;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RecordTypes;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RegistrationServiceMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.RelationshipTemplateSupport;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.ServiceDescription;
import org.eclipse.cosmos.dc.cmdbf.services.internal.metadata.transform.input.artifacts.XpathSupport;

/**
 * Factory for creating artifacts needed for CMDBf metadata
 * 
 * @provisional
 * @author Bill Muldoon
 * @author David Whiteman
 */
public class MetadataArtifactFactory implements IMetadataArtifactFactory {
	private static IMetadataArtifactFactory instance;

	public static IMetadataArtifactFactory getInstance() {
		if (instance == null) {
			instance = new MetadataArtifactFactory();
		}

		return instance;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createQueryServiceMetadata()
	 */
	public IQueryServiceMetadata createQueryServiceMetadata()
	{
		return new QueryServiceMetadata();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRegistrationServiceMetadata()
	 */
	public IRegistrationServiceMetadata createRegistrationServiceMetadata()
	{
		return new RegistrationServiceMetadata();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createServiceDescription()
	 */
	public IServiceDescription createServiceDescription()
	{
		return new ServiceDescription();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createQueryCapabilities()
	 */
	public IQueryCapabilities createQueryCapabilities()
	{
		return new QueryCapabilities();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRelationshipTemplateSupport()
	 */
	public IRelationshipTemplateSupport createRelationshipTemplateSupport()
	{
		return new RelationshipTemplateSupport();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createContentSelectorSupport()
	 */
	public IContentSelectorSupport createContentSelectorSupport()
	{
		return new ContentSelectorSupport();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRecordConstraintSupport()
	 */
	public IRecordConstraintSupport createRecordConstraintSupport()
	{
		return new RecordConstraintSupport();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createXpathSupport()
	 */
	public IXpathSupport createXpathSupport()
	{
		return new XpathSupport();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createDialect()
	 */
	public IDialect createDialect()
	{
		return new Dialect();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createPropertyValueOperators()
	 */
	public IPropertyValueOperators createPropertyValueOperators()
	{
		return new PropertyValueOperators();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRecordTypeList()
	 */
	public IRecordTypeList createRecordTypeList()
	{
		return new RecordTypeList();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRecordTypes()
	 */
	public IRecordTypes createRecordTypes()
	{
		return new RecordTypes();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.metadata.transform.input.artifacts.IMetadataArtifactFactory#createRecordType()
	 */
	public IRecordType createRecordType()
	{
		return new RecordType();
	}
	
}
