/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.mdr.registration.common;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.dc.mdr.api.IMdrQuery;
import org.eclipse.cosmos.dc.mdr.exception.CMDBfException;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.w3c.dom.Element;

/**
 * The federating CMDB operation interface
 * 
 * @provisional
 * @author Ali Mehregani
 */
@ManagedResourceCapability(namespace=IFederatingCMDB.NAMESPACE_URI)
public interface IFederatingCMDB extends IMdrQuery
{
	/**
	 * The namespace
	 */
	public static final String NAMESPACE_URI = "http://www.eclipse.org/cosmos/federatingCMDBOperation";
	
	/**
	 * The prefix
	 */
	public String PREFIX = "cmdbf";
	
	/**
	 * The operation URI, QName, and request QName for register
	 */
	public String REGISTRATION_OP_URI = NAMESPACE_URI + "/register";
	public QName REGISTRATION_OP_QNAME = new QName(NAMESPACE_URI, "register", PREFIX);
	public QName REGISTRATION_REQUEST_QNAME = new QName(NAMESPACE_URI, "registrationRequest", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for registerMDREntries
	 */
	public String REGISTER_MDR_ENTRIES_OP_URI = NAMESPACE_URI + "/registerMDREntries";
	public QName REGISTER_MDR_ENTRIES_OP_QNAME = new QName(NAMESPACE_URI, "registerMDREntries", PREFIX);
	public QName REGISTER_MDR_ENTRIES_MDR_ID_QNAME = new QName(NAMESPACE_URI, "mdrReferences", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for registerMDREntries
	 */
	public String REGISTER_SELECTIVE_MDR_ENTRIES_OP_URI = NAMESPACE_URI + "/registerSelectiveMDREntries";
	public QName REGISTER_SELECTIVE_MDR_ENTRIES_OP_QNAME = new QName(NAMESPACE_URI, "registerSelectiveMDREntries", PREFIX);
	public QName REGISTER_SELECTIVE_MDR_ENTRIES_REQUEST_QNAME = new QName(NAMESPACE_URI, "selectiveRegistration", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for registerAll
	 */
	public String REGISTER_ALL_OP_URI = NAMESPACE_URI + "/registerAll";
	public QName REGISTER_ALL_OP_QNAME = new QName(NAMESPACE_URI, "registerAll", PREFIX);
	public QName REGISTER_ALL_MGT_DOMAIN_QNAME = new QName(NAMESPACE_URI, "managementDomainEPR", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for deregister
	 */
	public String DEREGISTER_OP_URI = NAMESPACE_URI + "/deregister";
	public QName DEREGISTER_OP_QNAME = new QName(NAMESPACE_URI, "deregister", PREFIX);
	public QName DEREGISTER_REQUEST_QNAME = new QName(NAMESPACE_URI, "deregistrationRequest", PREFIX);
	
		
	/**
	 * The operation URI, QName, and request QName for deregisterMDREntries
	 */
	public String DEREGISTER_MDR_ENTRIES_OP_URI = NAMESPACE_URI + "/deregisterMDREntries";
	public QName DEREGISTER_MDR_ENTRIES_OP_QNAME = new QName(NAMESPACE_URI, "deregisterMDREntries", PREFIX);
	public QName DEREGISTER_MDR_ENTRIES_MDR_ID_QNAME = new QName(NAMESPACE_URI, "mdrReferences", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for deregisterSelectiveEntries
	 */
	public String DEREGISTER_SELECTIVE_ENTRIES_OP_URI = NAMESPACE_URI + "/deregisterSelectiveEntries";
	public QName DEREGISTER_SELECTIVE_ENTRIES_OP_QNAME = new QName(NAMESPACE_URI, "deregisterSelectiveEntries", PREFIX);
	public QName DEREGISTER_SELECTIVE_ENTRIES_QUERY_QNAME = new QName(NAMESPACE_URI, "queryRequest", PREFIX);
	
	
	/**
	 * The operation URI, QName, and request QName for deregisterAll
	 */
	public String DEREGISTER_ALL_OP_URI = NAMESPACE_URI + "/deregisterAll";
	public QName DEREGISTER_ALL_OP_QNAME = new QName(NAMESPACE_URI, "deregisterAll", PREFIX);
	
	
	/**
	 * Names of elements 
	 */
	public static String MDR_ADDRESSES_ELEMENT = "mdrAddresses";
	public static String ADDRESS_ENTRY_ELEMENT = "addressEntry"; 
	public static String SELECTIVE_REGISTRATION_INPUT_ELEMENT = "selectiveRegistrationInput"; 
	public static final String MDR_IDS_ELEMENT = "mdrIDs";
	public static final String MDR_ENTRY_ELEMENT = "mdrEntry";
	public static final String MANAGEMENT_DOMAIN_ELEMENT = "managementDomain";
	
	
	/**
	 * Attribute names
	 */
	public static String END_POINT_REFERENCE_ATTRIBUTE = "endPointReference";
	public static String DEFAULT_RESOURCE_ID_ATTRIBUTE = "defaultResourceId";
	public static final String ID_ATTRIBUTE = "id";

	
	/**
	 * Used for registering items/relationships with a federating
	 * CMDB
	 * 
	 * @param registrationRequest The registration request
	 * @return An element corresponding to the response of the registration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element register(Element registrationRequest)  throws CMDBfException;
	
	
	/**
	 * Registers all items/relationships of the MDRs with the IDs
	 * passed in as argument.  If an MDR cannot be found, then the ID
	 * will be ignored.  
	 * 
	 * @param mdrReferences Address for a set of MDRs
	 * @return An element corresponding to the response of the registration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element registerMDREntries(Element mdrReferences) throws CMDBfException;
	
		
	
	/**
	 * Registers all items/relationships that are a result set of applying
	 * queryRequest to the MDRs with the IDs passed in. This method provides
	 * a mechanism for registering items/relationships using a query.
	 * 
	 * @param selectiveRegistration The query request to apply to the MDRs
	 * @return An element corresponding to the response of the registration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element registerSelectiveMDREntries(Element selectiveRegistration) throws CMDBfException;
	
	
	/**
	 * Registers all items/relationships from all active MDRs
	 * 
	 * @param managementDomainEPR The management domain end point reference
	 * @return An element corresponding to the response of the registration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element registerAll(Element managementDomainEPR) throws CMDBfException;
	
	
	/**
	 * Used for deregistering items/relationships with a federating
	 * CMDB
	 * 
	 * @param deregistrationRequest The deregistration request
	 * @return An element corresponding to the response of the deregistration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element deregister(Element deregistrationRequest)  throws CMDBfException;

	
	/**
	 * Deregisters all items/relationships of the MDRs with the IDs
	 * passed in as argument.  If an MDR cannot be found, the ID
	 * will be ignored.  
	 * 
	 * @param mdrReferences Address for a set of MDRs
	 * @return An element corresponding to the response of the deregistration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element deregisterMDREntries(Element mdrReferences) throws CMDBfException;
	
	
	/**
	 * Deregisters all items/relationships that are a result set of applying
	 * queryRequest to this federating CMDB. This method provides a mechanism 
	 * for deregistering items/relationships using a query.
	 * 
	 * @param queryRequest The query request to apply to the MDRs
	 * @return An element corresponding to the response of the deregistration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element deregisterSelectiveEntries(Element queryRequest) throws CMDBfException;	
	
	
	/**
	 * Deregisters all items/relationships from this federating CMDB
	 * 
	 * @return An element corresponding to the response of the deregistration
	 * @throws CMDBfException In case of an unexpected error
	 */
	@ManagedOperation
	public Element deregisterAll() throws CMDBfException;
}
