/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.mdr.registration.common.internal;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializerUtil
{
	public static Element findNode (Element element, String localName)
	{
		if (localName.equals(element.getNodeName()))
		{
			return element;
		}
		
		NodeList children = element.getChildNodes();
		for (int i = 0, childCount = children.getLength(); i < childCount; i++)
		{
			Node child = children.item(i);
			if (Node.ELEMENT_NODE == child.getNodeType() && localName.equals(child.getLocalName()))
			{
				return (Element)children.item(i);
			}			
		}
		
		return null;		
	}
}
