/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.service;

import org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;

/**
 * An item constraint handler is used to make requests of the
 * form: "Return me all items that satisfy the constraints of a constraint"
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IItemConstraintHandler extends IQueryHandler
{
	/**
	 * Handle the constraint passed in and return the results.  
	 * The returned collection is expected to be a subset of 
	 * the context argument.  That is, the returned collection must be 
	 * constructed by adding all or a subset of the items in context.
	 *  
	 * @param context The starting context.  
	 * @param constraint The constraint to be handled
	 * @return A collection of elements that is formed as a result of handling
	 * the passed in constraint.
	 * @throws CMDBfServiceException If the handler is not initialized before being
	 * executed
	 */
	public INodes execute (INodes context, IConstraint constraint) throws CMDBfServiceException;
}
