/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.service;

import org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;

/**
 * This type of handler is used to process an item template
 * in a CMDBf query request.  An item handler will typically include
 * a node in the result that is indicative of all nodes present in 
 * a Management Data Repository (MDR).  It's not recommended for clients
 * to return a response with object representations of all nodes 
 * available in an MDR. 
 * 
 * @provisional
 * @see IItemTemplateHandler
 * @author Ali Mehregani
 */
public interface IItemTemplateHandler extends IQueryHandler
{
	/**
	 * Execute this item template handler based on the template
	 * argument passed in.
	 * 
	 * @param itemTemplate The item template
	 * @return The nodes that are representative of processing this item template
	 * @throws CMDBfServiceException In case of any unexpected error
	 */
	public INodes execute (IItemTemplate itemTemplate) throws CMDBfServiceException;
}
