/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.service;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;

/**
 * A query handler factory is used to create handler classes for 
 * templates and template constraints specified in a CMDBf query.  Clients 
 * can choose to provide a subclass of {@link AbstractQueryHandlerFactory} or a 
 * direct implementation of this interface.
 * 
 * @provisional
 * @see AbstractQueryHandlerFactory
 * @author Ali Mehregani
 */
public interface IQueryHandlerFactory
{	
	/**
	 * Creates a handler class for an item template.  An item template
	 * handler is invoked before invoking any of its associated constraint
	 * handlers.
	 *  
	 * @return An item template handler
	 * @throws CMDBfServiceException In case of an error
	 */
	public IItemTemplateHandler createItemTemplateHandler() throws CMDBfServiceException;
	
	
	/**
	 * Creates an item handler based on the constraint that is
	 * passed in.
	 * 
	 * @param constraint The constraint
	 * @return The handler
	 * @throws UnsupportedHandlerException if a handler is not supported
	 */
    public IItemConstraintHandler createItemConstraintHandler(IConstraint constraint) throws CMDBfServiceException;
   
    
    /**
     * Creates a handler for a relationship template.  A relationship template
     * handler is invoked before invoking any of its associated constraint
     * handlers.
     * 
     * @return A relationship template
     * @throws CMDBfServiceException In case of an error
     */
    public IRelationshipTemplateHandler createRelationshipTemplateHandler() throws CMDBfServiceException;
    
    
	/**
	 * Creates a relationship handler based on the constraint that is
	 * passed in.
	 * 
	 * @param constraint The constraint
	 * @return The handler
	 * @throws UnsupportedHandlerException if a handler is not supported
	 */
    public IRelationshipConstraintHandler createRelationshipConstraintHandler(IConstraint constraint) throws CMDBfServiceException;
}
