/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.query.service.impl;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfMessages;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.osgi.util.NLS;

/**
 * An abstract implementation of the item template handler.
 * Adopters can extend this class or provide a direct implementation
 * of {@link IItemTemplateHandler}
 * 
 * @provisional
 * @author Ali Mehregani
 */
public abstract class AbstractItemTemplateHandler extends AbstractQueryHandler implements IItemTemplateHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler#execute(org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IItemTemplate)
	 */
	public INodes execute(IItemTemplate itemTemplate) throws CMDBfServiceException
	{
		if (!isInitialized())
		{
			throw new CMDBfServiceException (
					CMDBfServiceException.RECIEVER, 
					CMDBfServiceException.QUERY_ERROR,
					CMDBfMessages.faultsQueryError,
					CMDBfInternalUtility.createTextNode(NLS.bind(CMDBfMessages.faultsCommonUninitialized, this.getClass().getName())));
		}
		
		INodes nodes = getQueryOutputArtifactFactory().createNodes(itemTemplate);
		// Check to determine if the item template has any associated constraints 
		if (itemTemplate.getInstanceIdConstraint() != null || (itemTemplate.getRecordConstraints() != null && itemTemplate.getRecordConstraints().length > 0)||
			(itemTemplate.getXpathExpressions() != null && itemTemplate.getXpathExpressions().length > 0))
		{			
			nodes.setStartingContext(true);
		}
		else
		{
			appendAllItems(nodes);
		}
		
		return nodes;
	}


	protected IQueryOutputArtifactFactory getQueryOutputArtifactFactory() {
		return QueryOutputArtifactFactory.getInstance();
	}

	/**
	 * The purpose of this method is for an MDR to append all items
	 * to the nodes object passed in.
	 * 
	 * @param nodes The nodes
	 * @throws CMDBfServiceException In case of an error
	 */
	protected abstract void appendAllItems(INodes nodes) throws CMDBfServiceException;

}
