/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.dmtoolkit.common.ui;

import org.eclipse.cosmos.me.dmtoolkit.common.Utilities;
import org.eclipse.cosmos.me.dmtoolkit.common.artifacts.IProjectConfig;
import org.eclipse.cosmos.me.dmtoolkit.common.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/**
 * Wizard page for configuring basic properties of a data manager project.
 * 
 * @provisional
 * @author David Whiteman
 */
public class DataManagerConfigPage extends WizardPage {

	private IProjectConfig model = null;
	private Text packageNameTextField;
	private Text nameTextField;

	protected DataManagerConfigPage(String pageName) {
		super(pageName);
	}

	public void createControl(Composite parent) {
		final Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));

		String packageNameFieldInitialContents = getModel().getPackageName();
		this.packageNameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPagePackageNameField,
				packageNameFieldInitialContents, false);

		String generatedClassNameInitialContents = getModel().getName();
		this.nameTextField = Utilities.createLabelTextPair(composite, Messages.wizardPageGeneratedClassNameField, generatedClassNameInitialContents, false);

		setControl(composite);
		Dialog.applyDialogFont(composite);
	}

	public void setModel(Object model) {
		this.model = (IProjectConfig) model;
	}

	public IProjectConfig getModel() {
		return model;
	}

	public void transferStateToModel() {
		getModel().setName(this.nameTextField.getText());
		getModel().setPackageName(this.packageNameTextField.getText());
	}
}
