/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to decorate a ManagedResource with externally implemented capabilities 
 */
@Target(TYPE)
@Retention(RUNTIME)
public @interface ComposableManagedCapabilitySet {

	/**
	 * The set of capability classes to decorate the targeted 
	 * ManagedResource instance with. This annotation works
	 * in conjunction with the ManagedFrameworkAutowire, 
	 * ManagedResourceCapability, and ManagedResourceFactory  
	 * annotations to enable the framework to replicate the
	 * delcarative programming model exposed by Muse.xml  
	 */
	Class[] set() default {};
	
}
