/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a creator for a managed relation.
 *   
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface CreateManagedRelation {
	/**
	 * The name of the relation
	 * 
	 */
	String name() default "";
	/**
	 * The type of the relation
	 * 
	 */
	String type();
	/**
	 * The name of the class corresponding to the related resource. This name
	 * acts as a hint to the annotation processor to help identify add and remove
	 * methods.  
	 */
	String relatedClassName() default "";
	/** 
	 * The namespace to be used for the relation. If no namespace is provided, 
	 * the namespace of ManagedResource annotation will be used. 
	 * 
	 */
	String namespace() default "";
	/**
	 * The roles played by the participants in the relation. The first role 
	 * is assigned to the resource the container belongs to, and the second role
	 * is assigned to the resource being added. 
	 * 
	 * If no roles are proved, the default roles of "container" and "contained"
	 * are used.
	 */
	String[] roles() default {"container","contained"};
}
