/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate an event raised by an operation. 
 * 
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface ManagedEvent {
	/** 
	 * The namespace to be used for the event. If no namespace is provided, 
	 * and the event is declared as a member of a ManagedResource,
	 * then the ManagedResource annotation's namespacewill be used. If no namespace
	 * is provided, and the event is operation is declared as a member of a 
	 * ManagedResourceCapability, then the ManagedResourceCapability's namespace
	 * will be used.
	 */	
	String namespace() default "";

	/**
	 * The topic name for the event.
	 */
	String topic();

	/**
	 * A text description of the capability. 
	 * This attribute is intended for tooling support. 
	 * 
	 */		
	String description() default "";
	
	//Optional override for payload producer - returns Element or String (which will be converted)
	String payloadMethod() default "";
	
	/**
	 * The format of the event. If no format is specified, the event message content 
	 * will contain return value of the event-raising method. The only currently supported 
	 * event format is "wef".  
	 * 
	 */		
	String format() default "";
}
