/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

@Target({METHOD})
@Retention(RUNTIME)
public @interface ManagedEventConsumer {
	/**
	 * The topic name for the event.
	 */
	String topic();

	/**
	 * A text description of the capability. 
	 * This attribute is intended for tooling support. 
	 * 
	 */		
	String description() default "";
	
	//Optional override for payload consumer - converts Element to type)
	String payloadMethod() default "";
	
	/**
	 * The format of the event. If no format is specified, the event message content 
	 * will contain return value of the event-raising method. The only currently supported 
	 * event format is "wef".  
	 * 
	 */		
	String format() default "";

}
