/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to support "wef" format events. This annoation indicates a parameter
 * to be used to provide a wef event source description. The annotated parameter
 * must implement org.eclipse.cosmos.me.management.api.EventSource.
 */
@Target({PARAMETER})
@Retention(RUNTIME)
public @interface ManagedEventSource {
}
