/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static java.lang.annotation.ElementType.FIELD;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to support autowiring of 
 * Components within the management framework.
 */
@Target(FIELD)
@Retention(RUNTIME)
public @interface ManagedFrameworkAutowire {
	/**
	 * Name of the desired Component
	 */
	String name() default "";
	
	/**
	 * Class of the desired Capability. This attribute works 
	 * in conjunction with the ComposableManagedCapabilitySet
	 *  annotation
	 */
	Class capability() default Void.class;
}
