/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a manageable operation. 
 * 
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface ManagedOperation {
	
	String description() default "";

	/** 
	 * The namespace to be used for the operation. If no namespace is provided, 
	 * and the operation is declared as a member of a ManagedResource,
	 * then the ManagedResource annotation's namespacewill be used. If no namespace
	 * is provided, and the operation is operation is declared as a member of a 
	 * ManagedResourceCapability, then the ManagedResourceCapability's namespace
	 * will be used.
	 */
	String namespace() default "";
	
	//Support lifecycle model
	boolean isDestroyMethod() default false;
	
	/** 
	 * If true, the operation will not be exposed, but will
	 * act as a source of metadata for extending introspection 
	 * of the resource by metadata exchange. This annotation 
	 * is used in conjuction with MetaDataType to expose different
	 * types of metadata.
	 */
	boolean isMetaDataMethod() default false;
	
	/**
	 * The type of metadata the operation returns. This annotation is only
	 * valid when used with the isMetaDataMethod annotation. 
	 */
	String MetaDataType() default "";	
}
