/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static java.lang.annotation.ElementType.FIELD;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a manageable property. The class 
 * is expected to provide a get (and optionally a set) method for
 * the property.
 * 
 * The default behavior is to look for getXXX and setXXX, where XXX is the name of the
 * property. If no getXXX is found, isXXX may be used as a substitute.
 *   
 */
@Target(FIELD)
@Retention(RUNTIME)
public @interface ManagedProperty {
	/**
	 * A text description of the capability. 
	 * This attribute is intended for tooling support. 
	 * 
	 */	
	String description() default "";
	/** 
	 * The namespace to be used for the property. If no namespace is provided, 
	 * the namespace of ManagedResource annotation will be used. 
	 * 
	 */
	String namespace() default "";
	/** 
	 * If true, the property will be used to supply a unique resource
	 * identifier for the resource. The class is checked to ensure that 
	 * this is a read-only property, as the resource id must be constant
	 * for the life of the resource.
	 */
	boolean resourceID() default false;
	/** 
	 * If true, the resource will be exposed as part of a Configuration capability
	 * and be visible through introspection using that capability.
	 */
	boolean isConfigurationProperty() default false;
}
