/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a getter for a manageable property. This 
 * annotation is used with the ManagedResourceCapability annotation to 
 * indicate a property within a capability. 
 *   
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface ManagedPropertyGetter {
	/**
	 * A text description of the capability. 
	 * This attribute is intended for tooling support. 
	 * 
	 */	
	String description() default "";
	/** 
	 * The namespace to be used for the property. If no namespace is provided, 
	 * the namespace of ManagedResourceCapability annotation will be used. 
	 * 
	 */
	String namespace() default "";
	/** 
	 * The local name of the property.
	 */
	String property() default "";
}
