/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a class to be exposed as a manageable resource. 
 */
@Target(TYPE)
@Retention(RUNTIME)
public @interface ManagedResource {
	/**
	 * A text description of the resource. This value will be used as the
	 * default description when the resource is introspected.
	 */
	String description() default "";
	/**
	 * The namespace of the resource. This namespace will be used for all
	 * operations and properties exposed by this resource (unless overridden) 
	 * that are not part of some other capability  
	 */
	String namespace() default "";
	/**
	 * The desired persistence model for the resource.   
	 */
	String persistent() default "never";
	
	/**
	 * If true, indicates that the resource should support advertisement, and
	 * that the initial advertisementConsumer should be honored.   
	 */
	boolean advertise() default false;
	/**
	 * A text string used by the management host to identify the
	 * endpoint of an initial advertisement. This attribute is only used
	 * if advertise is true.   
	 */
	String advertisementConsumer() default "";
	
	/**
	 * A name used to supply a target for AutoWire-annotated
	 * fields in other managed components.
	 */
	String autowireName() default "";
	
}
