/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate an interface which to be exposed as a distinct 
 * management capability. 
 */
@Target(TYPE)
@Retention(RUNTIME)
public @interface ManagedResourceCapability {
	
	/**
	 * A text description of the capability. 
	 * This attribute is intended for tooling support. 
	 * 
	 */
	String description() default "";
	/**
	 * The namespace of the capability. This namespace will be used for all
	 * operations and properties exposed by this capability (unless overridden) 
	 * and will uniquely identify the capability when introspecting its resource.  
	 */
	String namespace();
	
	/**
	 * Used to expose a particular management type. Populating this field will cause
	 * the runtime to expose the implementation directly in the binding, without
	 * the implementation  
	 */
	String[] bindings() default {};
	
	/**
	 * Indicates that the annotated implementation may be used in conjunction
	 * with the ComposableManagedCapabilitySet annotation to implement a 
	 * composite managed resource  
	 */
	boolean composable() default true;
}
