/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation used to indicate a factory method to construct a framework component. 
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface ManagedResourceFactory {
	
	/**
	 * If true, indicates that the resource is a singleton, and only the default 
	 * instance may be registered. All other instances attempting to register will
	 * be rejected   
	 */
	boolean singleton() default false;
	
}
