/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.api;

import javax.xml.namespace.QName;

public interface EventSituation {
    static final short LOWEST_PRIORITY = 0;
    static final short LOW_PRIORITY = 10;
    static final short MEDIUM_PRIORITY = 50;
    static final short HIGH_PRIORITY = 70;
    static final short HIGHEST_PRIORITY = 100;

    static final short UNKNOWN_SEVERITY = 0;
    static final short INFO_SEVERITY = 1;
    static final short WARNING_SEVERITY = 2;
    static final short MINOR_SEVERITY = 3;
    static final short MAJOR_SEVERITY = 4;
    static final short CRITICAL_SEVERITY = 5;
    static final short FATAL_SEVERITY = 6;

    static final String SUCCESSFUL = "Successful";

    static final String UNSUCCESSFUL = "Unsuccessful";

    QName getCategoryType();
	String getMessage();
	short getPriority();
	short getSeverity();
	String getSuccessDisposition();
	

}
