/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.StatusChangeListener;

public interface Binding extends StatusChangeListener {
	
	public static String PROVIDER_NAME = "Provider";
	public static String PROVIDER_MAJOR_VERSION = "Major";
	public static String PROVIDER_MINOR_VERSION = "Minor";
	
	void bindContribution(Object contribution, boolean register);
	void unbindContribution(Object contribution);

	void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations);
	
	void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations);
	
	void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations);
	
	Object getBindingForObject(Object boundObject);
	
	STATUS getStatus();
	
	String getBindingName();
	
	public void setContributionManager(ContributionManager manager);
	
}
