package org.eclipse.cosmos.me.management.common;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

import javax.management.IntrospectionException;
import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.management.annotations.ComposableManagedCapabilitySet;
import org.eclipse.cosmos.me.management.annotations.CreateManagedRelation;
import org.eclipse.cosmos.me.management.annotations.DestroyManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedEventConsumer;
import org.eclipse.cosmos.me.management.annotations.ManagedFrameworkAutowire;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertyGetter;
import org.eclipse.cosmos.me.management.annotations.ManagedPropertySetter;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceFactory;
import org.eclipse.cosmos.me.management.common.util.BindingUtil;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedAttributeInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationConsumerInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedNotificationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedOperationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedRelationInfo;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;

public class BindingStructureHelper {
	
	public static final ManagedAttributeInfo[] EMPTY_ATTR_INFO_ARRAY ={};
	public static final ManagedOperationInfo[] EMPTY_OPER_INFO_ARRAY ={};
	public static final ManagedRelationInfo[] EMPTY_RELATION_INFO_ARRAY ={};
	public static final ManagedNotificationInfo[] EMPTY_NOTIFICATION_INFO_ARRAY ={};
	public static final ManagedNotificationConsumerInfo[] EMPTY_NOTIFICATION_CONSUMER_INFO_ARRAY ={};
	public static final ComposedCapabilityInfo[] EMPTY_COMPOSED_INFO_ARRAY ={};
	public static final Field[] EMPTY_FIELD_ARRAY = {};
	public static final String[] EMPTY_CAPABILITY_ARRAY = {};
	
	private static WeakHashMap<Class, ManagedResourceInfo> boundClassMap = new WeakHashMap<Class, ManagedResourceInfo>();
	private static HashMap<String, Class> capabilityFactoryMap = new HashMap<String, Class>();
	private static ContributionManager manager;
	private static ArrayList<IBindingListener> listenerList = new ArrayList<IBindingListener>();
	
	public static synchronized ManagedResourceInfo getResourceInfo(Object resource){
		Class resourceClass = resource.getClass();
		if(Proxy.isProxyClass(resourceClass) && ManagementProxy.class.isAssignableFrom(resourceClass)){
			resourceClass = ((ManagementProxy)resource).getProxiedClass();
		}
		return boundClassMap.get(resourceClass);
	}
	
	public static void setContributionManager(ContributionManager cm){
		manager = cm;
	}
	
	
	private ArrayList<ManagedAttributeInfo> attrInfoList = new ArrayList<ManagedAttributeInfo>();
	private ArrayList<ManagedOperationInfo> operInfoList = new ArrayList<ManagedOperationInfo>();
	private ArrayList<ManagedNotificationInfo> notificationInfoList = new ArrayList<ManagedNotificationInfo>();
	private ArrayList<ManagedNotificationConsumerInfo> notificationConsumerInfoList = new ArrayList<ManagedNotificationConsumerInfo>();
	private ArrayList<ManagedRelationInfo> relationInfoList = new ArrayList<ManagedRelationInfo>();
	private ArrayList<ComposedCapabilityInfo> composedInfoList = new ArrayList<ComposedCapabilityInfo>();
	private HashMap<String, String> internalCapabilityMap = new HashMap<String,String>();
	
	protected void processResourceCapability(ManagedResourceCapability capability, 
			Class capabilityClass,
			ArrayList<ManagedAttributeInfo> attrInfoList,
			ArrayList<ManagedOperationInfo> operInfoList,
			ArrayList<ManagedRelationInfo> relationInfoList,
			ArrayList<ManagedNotificationInfo> notificationInfoList,
			ArrayList<ManagedNotificationConsumerInfo> notificationConsumerInfoList){
		
		String ownerNamespace = capability.namespace();
		Method methods[] = capabilityClass.getMethods();
		HashMap<QName, Method> propsGetterMap = new HashMap<QName, Method>();
		HashMap<QName, Method> propsSetterMap = new HashMap<QName, Method>();
		for(Method method: methods){
			ManagedOperation operation_annotation = (ManagedOperation)BindingUtil.getMethodAnnotation(ManagedOperation.class, method);
			CreateManagedRelation create_annotation = (CreateManagedRelation)BindingUtil.getMethodAnnotation(CreateManagedRelation.class, method);
			DestroyManagedRelation destroy_annotation = (DestroyManagedRelation)BindingUtil.getMethodAnnotation(DestroyManagedRelation.class, method);
			ManagedEvent event_annotation = (ManagedEvent)BindingUtil.getMethodAnnotation(ManagedEvent.class, method);
			ManagedEventConsumer event_consumer = (ManagedEventConsumer)BindingUtil.getMethodAnnotation(ManagedEventConsumer.class, method);
			ManagedPropertyGetter prop_getter_annotation = (ManagedPropertyGetter)BindingUtil.getMethodAnnotation(ManagedPropertyGetter.class, method);
			ManagedPropertySetter prop_setter_annotation = (ManagedPropertySetter)BindingUtil.getMethodAnnotation(ManagedPropertySetter.class, method);
			String capabilityURI = null;
			ManagedOperationInfo operation = null;
			if(operation_annotation != null){
				operation = processOperation(operation_annotation, method);
				operInfoList.add(operation);
			}else if(create_annotation != null){
				relationInfoList.add(processRelation(create_annotation, method));
			}else if(destroy_annotation != null){
				relationInfoList.add(processRelation(destroy_annotation, method));
			}else if(event_consumer != null){
				operation = processOperation(event_consumer, method);
				operInfoList.add(operation);
			}else if(prop_getter_annotation != null){
				String namespace = prop_getter_annotation.namespace();
				if("".equals(namespace)) namespace = capability.namespace();
				QName propName = new QName(namespace, prop_getter_annotation.property());
				propsGetterMap.put(propName, method);
			}else if(prop_setter_annotation != null){
				String namespace = prop_setter_annotation.namespace();
				if("".equals(namespace)) namespace = capability.namespace();
				QName propName = new QName(namespace, prop_setter_annotation.property());
				propsSetterMap.put(propName, method);
			}
			if(event_annotation != null){
				ManagedNotificationInfo notification = processNotification(event_annotation, method, capabilityClass);
				if(capabilityURI != null){
					notification.setSpecCapabilityURI(capabilityURI);
				}
				notificationInfoList.add(notification);
			}else if(event_consumer != null && operation != null){
				ManagedNotificationConsumerInfo consumer = processNotificationConsumer(event_consumer, method, capabilityClass, operation);
				if(capabilityURI != null){
					consumer.setSpecCapabilityURI(capabilityURI);
				}
				notificationConsumerInfoList.add(consumer);
			}
		}

		if(!propsGetterMap.isEmpty()){
			QName[] propNames = propsGetterMap.keySet().toArray(new QName[]{});
			for(QName propName : propNames){
				Method getter = propsGetterMap.remove(propName);
				Method setter = propsSetterMap.remove(propName);
				attrInfoList.add(processProperty(propName, ownerNamespace, getter, setter));
			}
		}
	}
	
	protected ManagedResourceInfo processResource(ManagedResource resource, Class resourceClass){

		String resourceNamespace = resource.namespace();
		if("".equals(resourceNamespace)){
			ArrayList<String> namespaceList = new ArrayList();
			StringTokenizer toker = new StringTokenizer(resourceClass.getName(),".");
			while(toker.hasMoreTokens()){
				namespaceList.add(toker.nextToken());
			}
			String[] names = namespaceList.toArray(new String[]{});
			StringBuffer namespaceBuffer = new StringBuffer("http:/");
			if(names.length < 2) namespaceBuffer.append("/default");
			else{
				for(int i=names.length-2;i>=0;i--)
					namespaceBuffer.append("/"+names[i]);
			}
			resourceNamespace = namespaceBuffer.toString();
		}
		HashMap<String,Field> map = new HashMap<String,Field>();
		Class workingClass = resourceClass;
		while(workingClass != java.lang.Object.class){
			BindingUtil.extractFields(workingClass,map);
			workingClass = workingClass.getSuperclass();
		}
		
		//Check interfaces:
		Class ifaces[] = resourceClass.getInterfaces();
		for(Class iface : ifaces){
			ManagedResourceCapability capability_annotation = (ManagedResourceCapability)BindingUtil.getAnnotation(ManagedResourceCapability.class, iface);
			if(capability_annotation != null){
				internalCapabilityMap.put(capability_annotation.namespace(), capability_annotation.namespace());
			}
			
		}
		
		Field fields[] = map.values().toArray(EMPTY_FIELD_ARRAY);
		for(Field field: fields){
			ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
			ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
			ManagedEvent event_annotation = field.getAnnotation(ManagedEvent.class);
			ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
			if(relation_annotation != null){
				relationInfoList.add(processRelation(relation_annotation, field));
			} else if(property_annotation != null){
				attrInfoList.add(processProperty(property_annotation, field, resource, resourceClass, resourceNamespace));
			}
			if(event_annotation != null){
				ManagedNotificationInfo notificationInfo = processNotification(event_annotation, field, resourceClass);
				//WSRF property change notifications basic to WSRF/WSN
				//FIXME what should this do?
				//notificationInfo.setSpecCapabilityURI(WsrfConstants.NAMESPACE_URI);
				notificationInfoList.add(notificationInfo);
			}
		}
		Method methods[] = resourceClass.getMethods();
		HashMap<QName, Method> propsGetterMap = new HashMap<QName, Method>();
		HashMap<QName, Method> propsSetterMap = new HashMap<QName, Method>();
		HashMap<QName, String> propsCapabilityMap = new HashMap<QName, String>();
		for(Method method: methods){
			ManagedOperation operation_annotation = (ManagedOperation)BindingUtil.getMethodAnnotation(ManagedOperation.class, method);
			CreateManagedRelation create_annotation = (CreateManagedRelation)BindingUtil.getMethodAnnotation(CreateManagedRelation.class, method);
			DestroyManagedRelation destroy_annotation = (DestroyManagedRelation)BindingUtil.getMethodAnnotation(DestroyManagedRelation.class, method);
			ManagedEvent event_annotation = (ManagedEvent)BindingUtil.getMethodAnnotation(ManagedEvent.class, method);
			ManagedEventConsumer event_consumer = (ManagedEventConsumer)BindingUtil.getMethodAnnotation(ManagedEventConsumer.class, method);
			ManagedPropertyGetter prop_getter_annotation = (ManagedPropertyGetter)BindingUtil.getMethodAnnotation(ManagedPropertyGetter.class, method);
			ManagedPropertySetter prop_setter_annotation = (ManagedPropertySetter)BindingUtil.getMethodAnnotation(ManagedPropertySetter.class, method);
			ManagedResourceCapability capability_annotation = (ManagedResourceCapability)BindingUtil.getMethodAnnotation(ManagedResourceCapability.class, method);
			
			ManagedOperationInfo operation = null;
			String capabilityURI = null;
			
			if(operation_annotation != null){
				operation = processOperation(operation_annotation, method);
				operInfoList.add(operation);
			}else if(create_annotation != null){
				//capabilityURI = MuwsConstants.RELATIONSHIPS_URI;
				relationInfoList.add(processRelation(create_annotation, method));
			}else if(destroy_annotation != null){
				//capabilityURI = MuwsConstants.RELATIONSHIPS_URI;
				relationInfoList.add(processRelation(destroy_annotation, method));
			}else if(event_consumer != null){
				operation = processOperation(event_consumer, method);
				operInfoList.add(operation);
			}else if(prop_getter_annotation != null){
				String namespace = "";
				String propNamespace = resourceNamespace;
				namespace = prop_getter_annotation.namespace();
				if(capability_annotation != null){
					propNamespace = capability_annotation.namespace();
					if("".equals(namespace)){
						namespace = propNamespace;
					}
				}
				QName propName = new QName(namespace, prop_getter_annotation.property());
				propsGetterMap.put(propName, method);
				String prevNamespace = propsCapabilityMap.get(propName);
				if(prevNamespace != null && !namespace.equals(prevNamespace)){
					notifyListener(IBindingListener.ERROR, IBindingListener.PROPERTY_NAMESPACE_MISMATCH, new Object[]{propName});
				}else{
					propsCapabilityMap.put(propName, propNamespace);
				}
			}else if(prop_setter_annotation != null){
				String namespace = "";
				String propNamespace = resourceNamespace;
				namespace = prop_setter_annotation.namespace();
				if(capability_annotation != null){
					propNamespace = capability_annotation.namespace();
					if("".equals(namespace)){
						namespace = propNamespace;
					}
				}
				QName propName = new QName(namespace, prop_setter_annotation.property());
				propsSetterMap.put(propName, method);
				String prevNamespace = propsCapabilityMap.get(propName);
				if(prevNamespace != null && !namespace.equals(prevNamespace)){
					notifyListener(IBindingListener.ERROR, IBindingListener.PROPERTY_NAMESPACE_MISMATCH, new Object[]{propName});
				}else{
					propsCapabilityMap.put(propName, propNamespace);
				}
			}
			if(event_annotation != null /*&& operation != null*/){
				ManagedNotificationInfo notificationInfo = processNotification(event_annotation, method, resourceClass);
				if(capabilityURI != null){
					notificationInfo.setSpecCapabilityURI(capabilityURI);
				}
				notificationInfoList.add(notificationInfo);

			}else if(event_consumer != null){
				ManagedNotificationConsumerInfo consumer = processNotificationConsumer(event_consumer, method, resourceClass, operation);
				if(capabilityURI != null){
					consumer.setSpecCapabilityURI(capabilityURI);
				}
				notificationConsumerInfoList.add(consumer);
			}
		}

		if(!propsGetterMap.isEmpty()){
			for(QName propName : propsGetterMap.keySet()){
				Method getter = propsGetterMap.get(propName);
				Method setter = propsSetterMap.remove(propName);
				attrInfoList.add(processProperty(propName, propsCapabilityMap.get(propName), getter, setter));
			}
		}
		
		//collect all the capability namespaces
		for(ManagedOperationInfo oper : operInfoList){
			System.out.println("Oper " + oper.getNamespace());
			if("".equals(oper.getNamespace()))continue;
			internalCapabilityMap.put(oper.getNamespace(), oper.getNamespace());
		}
		for(ManagedAttributeInfo attr : attrInfoList){
			System.out.println("Attr " + attr.getOwnerNamespace());
			internalCapabilityMap.put(attr.getOwnerNamespace(), attr.getOwnerNamespace());
		}

		return new ManagedResourceInfo(resourceClass, resourceClass.getName(),resource.description(),
				resourceNamespace,
				internalCapabilityMap.keySet().toArray(EMPTY_CAPABILITY_ARRAY),				
				attrInfoList.toArray(EMPTY_ATTR_INFO_ARRAY),
				null,
				operInfoList.toArray(EMPTY_OPER_INFO_ARRAY),
				relationInfoList.toArray(EMPTY_RELATION_INFO_ARRAY),
				notificationInfoList.toArray(EMPTY_NOTIFICATION_INFO_ARRAY),
				notificationConsumerInfoList.toArray(EMPTY_NOTIFICATION_CONSUMER_INFO_ARRAY),
				composedInfoList.toArray(EMPTY_COMPOSED_INFO_ARRAY),
				BindingUtil.getAnnotations(resourceClass));
	}

	protected ManagedRelationInfo processRelation(ManagedRelation relation, Field field){
		return new ManagedRelationInfo(relation, field);
	}

	protected ManagedRelationInfo processRelation(CreateManagedRelation relation, Method method){
		return new ManagedRelationInfo(method.getAnnotations(), method, true);
	}

	protected ManagedRelationInfo processRelation(DestroyManagedRelation relation, Method method){
		return new ManagedRelationInfo(method.getAnnotations(), method, false);
	}

	protected ManagedAttributeInfo processProperty(ManagedProperty property, Field field, ManagedResource resource, Class resourceClass, String namespace){

		String description = property.description();
		String name = field.getName();
		if(name.length() == 1) name = name.toUpperCase();
		else name = name.substring(0,1).toUpperCase() + name.substring(1, name.length());
		String getterName = "get" + name;
		String setterName = "set" + name;

		Class[] setterParm = {field.getType()};
		Class[] getterParm = {};
		Method getterMethod = null;
		Method setterMethod = null;
		try {
			getterMethod = resourceClass.getMethod(getterName, getterParm);
			//TODO Too stringent???
			if(!getterMethod.getReturnType().equals(field.getType())){
				getterMethod = null;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		}

		try {
			setterMethod = resourceClass.getMethod(setterName, setterParm);
			//TODO Too stringent???
			if(!setterMethod.getReturnType().equals(void.class)){
				setterMethod = null;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		}

		try {
			String ns = property.namespace();
			if("".equals(ns)) ns = namespace;
			return new ManagedAttributeInfo(field.getName(), ns, namespace, description, getterMethod, setterMethod, field.getAnnotations());
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return null;
	}


	protected ManagedAttributeInfo processProperty(QName propName, String ownerNamespace, Method getterMethod, Method setterMethod){

		String description = "";
		Class retType = getterMethod.getReturnType();

		if(setterMethod != null){
			Class[] parmTypes = setterMethod.getParameterTypes();
			if(parmTypes.length != 1) return null;
			if(!parmTypes[0].equals(retType)) return null;
		}

		try {
			return new ManagedAttributeInfo(propName.getLocalPart(), propName.getNamespaceURI(), ownerNamespace, description, getterMethod, setterMethod, BindingUtil.getAnnotations(getterMethod));
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return null;
	}


	protected static ManagedNotificationInfo processNotification(ManagedEvent event, Field field, Class resourceClass){
		//TODO make some reasonable defaults, or at least some way to tell that this is a prop change
		return new ManagedNotificationInfo(new String[]{},event.topic(),event.description(), event.namespace(),null);
	}

	protected static ManagedNotificationInfo processNotification(ManagedEvent event, Method method, Class resourceClass){
		//TODO make some reasonable defaults, or at least some way to tell that this is a prop change
		String namespace = event.namespace();
		if("".equals(event.namespace())){
			Class[] interfazes = resourceClass.getInterfaces();
			for(Class interfaze : interfazes){
				ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotationFromInterface(ManagedResourceCapability.class, interfaze);
				if(cap == null)continue;
				Method[] methods = interfaze.getMethods();
				for(Method imethod : methods){
					if(BindingUtil.equivalentMethod(method, imethod)){
						namespace = cap.namespace();
						break;
					}
				}
				if(!"".equals(namespace)) break;
			}
		}
		return new ManagedNotificationInfo(new String[]{},event.topic(),event.description(), namespace,null);
	}

	protected static ManagedNotificationConsumerInfo processNotificationConsumer(ManagedEventConsumer event, Method method, Class resourceClass, ManagedOperationInfo operation){
		//TODO make some reasonable defaults, or at least some way to tell that this is a prop change
		String namespace = "";
		Class[] interfazes = resourceClass.getInterfaces();
		for(Class interfaze : interfazes){
			ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotationFromInterface(ManagedResourceCapability.class, interfaze);
			if(cap == null)continue;
			Method[] methods = interfaze.getMethods();
			for(Method imethod : methods){
				if(BindingUtil.equivalentMethod(method, imethod)){
					namespace = cap.namespace();
					break;
				}
			}
			if(!"".equals(namespace)) break;
		}
		return new ManagedNotificationConsumerInfo(new String[]{},event.topic(),event.description(), namespace,null, operation);
	}

	protected static ManagedOperationInfo processOperation(ManagedOperation operation, Method method){
		return new ManagedOperationInfo(operation.description(), method, BindingUtil.getAnnotations(method), BindingUtil.getParameterAnnotations(method));
	}

	protected static ManagedOperationInfo processOperation(ManagedEventConsumer consumer, Method method){
		return new ManagedOperationInfo("event consumer", method, BindingUtil.getAnnotations(method), BindingUtil.getParameterAnnotations(method));
	}
	
	public ManagedResourceInfo register(Object resource) throws Exception {
		Class<? extends Object> resourceClass = resource.getClass();
		if(Proxy.isProxyClass(resourceClass) && ManagementProxy.class.isAssignableFrom(resourceClass)){
			resourceClass = ((ManagementProxy)resource).getProxiedClass();
		}

		ManagedResourceInfo managedInfo = boundClassMap.get(resourceClass);

		if(managedInfo == null){

			ManagedResource resource_annotation = (ManagedResource)BindingUtil.getAnnotation(ManagedResource.class, resourceClass);
			if(resource_annotation == null){
				throw new Exception("Invalid Resource - does not contain ManagedResource annotation: " + resource.getClass().getName());
			}
			


			//Check for composition model
			ComposableManagedCapabilitySet compositionSet = (ComposableManagedCapabilitySet)BindingUtil.getAnnotation(ComposableManagedCapabilitySet.class, resourceClass);
			if(compositionSet != null){
				Class[] compositionTargets = compositionSet.set();
				for(Class target : compositionTargets){
					
					//Verify composition elements are capabilities
					ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotation(ManagedResourceCapability.class, target);
					if(cap == null){
						throw new Exception("Unable to Bind - invalid composition");
					}
					
					//Determine construction mechanism for composition targets
					ManagedResourceFactory factory = (ManagedResourceFactory)BindingUtil.getAnnotation(ManagedResourceFactory.class, target);
					
					processResourceCapability(cap, target, attrInfoList, operInfoList, relationInfoList, notificationInfoList, notificationConsumerInfoList);
					composedInfoList.add(new ComposedCapabilityInfo(cap, target));
					
				}
			}

			managedInfo = processResource(resource_annotation, resourceClass);


			boundClassMap.put(resourceClass,managedInfo);
			//FIXME resolve context root from manifest
		}

		return managedInfo;

	}

	//TODO - don't forget, need to cache for this class so the autowire can be done for all instances
	public static void processAutowire(Object resource, ManagedFrameworkAutowire autowire, Field field, Class<? extends Object> targetClass, 
			Object target, ComposedCapabilityInfo composedInfoList[], HashMap<String, Object> capImplMap) {
		String name = field.getName();
		if(name.length() == 1) name = name.toUpperCase();
		else name = name.substring(0,1).toUpperCase() + name.substring(1, name.length());
		String setterName = "set" + name;

		Class[] setterParm = {field.getType()};
		Method setterMethod = null;
		
		Object autowireTarget = null;
		if(autowire.capability() != Void.class){
			for(ComposedCapabilityInfo info : composedInfoList){
				if(info.getImplClass().equals(autowire.capability())){
					autowireTarget = capImplMap.get(info.getNamespace());
					break;
				}
			}
		} else if("$RESOURCE".equals(autowire.name())){
			autowireTarget = resource;
		}else{
			autowireTarget = manager.getAutowireTarget(autowire.name());
		}

		if(autowireTarget != null && field.getType().isAssignableFrom(autowireTarget.getClass())){
			try {
				setterMethod = targetClass.getMethod(setterName, setterParm);
				//TODO Too stringent???
				if(!setterMethod.getReturnType().equals(void.class)){
					setterMethod = null;
				}
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
			}
			try {
				if(setterMethod != null){
					Object impl = target;
					if(target instanceof ManagementProxy){
						impl = ((ManagementProxy)target).getProxiedObject();
					}
					setterMethod.invoke(impl, new Object[]{autowireTarget});
				}
			}catch(Throwable t){
				t.printStackTrace();
			}
		}
	}

	public static void processAutowire(ManagedResourceInfo info, Object resource, HashMap<String, Object> capImplMap) {
		ComposedCapabilityInfo composedCapabilities[] = info.getComposedCapabilities();

		HashMap<String,Field> map = new HashMap<String,Field>();
		Class resourceClass = info.getResourceClass();
		
		//Autowire resource class
		Class workingClass = resourceClass;
		while(workingClass != java.lang.Object.class){
			BindingUtil.extractFields(workingClass,map);
			workingClass = workingClass.getSuperclass();
		}
		Field fields[] = map.values().toArray(EMPTY_FIELD_ARRAY);
		for(Field field: fields){
			ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
			if(autowire != null){
				processAutowire(resource, autowire, field, resourceClass, resource, composedCapabilities, capImplMap);
			}
		}
		
		for(ComposedCapabilityInfo capInfo : composedCapabilities){
			workingClass = capInfo.getImplClass();
			while(workingClass != null && workingClass != java.lang.Object.class){
				BindingUtil.extractFields(workingClass,map);
				workingClass = workingClass.getSuperclass();
			}
			fields = map.values().toArray(EMPTY_FIELD_ARRAY);			
			for(Field field: fields){
				ManagedFrameworkAutowire autowire = field.getAnnotation(ManagedFrameworkAutowire.class);
				if(autowire != null){
					processAutowire(resource, autowire, field, capInfo.getImplClass(), capImplMap.get(capInfo.getNamespace()), composedCapabilities, capImplMap);
				}
			}
		}
	}

	public static void setCapabilityFactory(String uri, Class factory) {
		capabilityFactoryMap.put(uri, factory);
	}
	
	public static Class getCapabilityFactory(String uri) {
		return capabilityFactoryMap.get(uri);
	}
	public static Object instantiateCapability(String uri, Class target) throws Exception {
		//Determine construction mechanism for composition targets
		ManagedResourceFactory factory = (ManagedResourceFactory)BindingUtil.getAnnotation(ManagedResourceFactory.class, target);
		Object capImpl = null;
		if(factory != null){
			//Use the factory
			System.out.println("Using factory");
		}else if(target.isInterface() && capabilityFactoryMap.get(uri) != null){
			System.out.println("Using default factory");
			Class targetFactory  = capabilityFactoryMap.get(uri);
			if(targetFactory != null){
				try {
					Method factoryMethod = targetFactory.getMethod("create", new Class[]{});
					if(factoryMethod != null){
						System.out.println(Modifier.isStatic(factoryMethod.getModifiers()));
						System.out.println(factoryMethod.isAccessible());
						capImpl = factoryMethod.invoke(null, new Object[]{});
					}
				}catch(Throwable t){
					capImpl = targetFactory.newInstance();
				}
			}
		}else {
			try{
				capImpl = target.newInstance();
			}catch(Throwable t){
				t.printStackTrace();
				throw new RuntimeException("Failed to create Capability instance for " + uri + " Class:" + target.getName());
			}
		}
		return capImpl;
	}
	
	public static void addListener(IBindingListener listener){
		BindingStructureHelper.listenerList.add(listener);
	}

	public static void removeListener(IBindingListener listener){
		BindingStructureHelper.listenerList.remove(listener);
	}
	
	private void notifyListener(int serverity, String messageId, Object[] parms){
		for(IBindingListener listener : listenerList){
			listener.notify(serverity, messageId, parms);
		}
	}

	private void notifyListener(int serverity, String messageId, Object[] parms, Throwable t){
		for(IBindingListener listener : listenerList){
			listener.notify(serverity, messageId, parms, t);
		}
	}
}
