/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public interface ContributionManager extends StatusChangeListener  {
	
	void initialize(BindingProvider bindingProvider);
	
	Object manage(Object object) throws Exception;
	
	Object manage(Class clazz);
	
	void remove(Object object);
	
	void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations);
	
	void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations);
	
	void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations);
	
	Object getAutowireTarget(String name);
	
	boolean addAutowireTarget(String name, Object obj);
	
	boolean registerAutowireTargetFactory(Class capabilties[], Object factory);
}
