/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;

public class ComposedCapabilityInfo {
	
	private ManagedResourceCapability capability;
	private Class implClass;
	
	public ComposedCapabilityInfo(ManagedResourceCapability capability, Class implClass){
		this.capability = capability;
		this.implClass = implClass;
	}
	
	public String getNamespace(){
		return capability.namespace();
	}

	public Class getImplClass(){
		return implClass;
	}

}
