/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;

import org.eclipse.cosmos.me.management.annotations.ManagedMetric;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.w3c.dom.Element;

public class ManagedAttributeInfo extends MBeanAttributeInfo {

	/**
	 * 
	 */
	private static final long serialVersionUID = -522324273721709618L;
	private boolean isResourceID = false;
	private boolean isMetric = false;
	private Method getter;
	private Method setter;
	private ManagedMetric metric;
	private Annotation[] annotations;
	private String namespace;
	private String ownerNamespace;
	
	public boolean isResourceID(){
		return isResourceID;
	}
	
	public boolean isMetric(){
		return isMetric;
	}
	
	public String getNamespace(){
		return namespace;
	}
	
	public String getOwnerNamespace(){
		return ownerNamespace;
	}
	
	public ManagedAttributeInfo(String name, String namespace, String ownerNamespace, String description, Method getter, Method setter, Annotation[] annotations) throws IntrospectionException {
		super(name, description, getter, setter);
		this.getter = getter;
		this.setter = setter;
		this.annotations = annotations;
		this.namespace = namespace;
		this.ownerNamespace = ownerNamespace;
		for(Annotation annotation : annotations){
			if(annotation instanceof ManagedProperty){
				isResourceID = ((ManagedProperty)annotation).resourceID();
			}else if(annotation instanceof ManagedMetric){
				metric = (ManagedMetric)annotation;
				isMetric = true;
			}
		}
	}
	
	public Method getGetter(){
		return getter;
	}
	
	public Method getSetter(){
		return setter;
	}
	
	public Annotation[] getAnnotations(){
		return annotations;
	}
	
	public Annotation getAnnotation(Class target){
		for(Annotation annotation : annotations){
			if(annotation.equals(target))return annotation;
		}
		return null;
	}
	
	//<xsd:element name="MyProperty" type="xsd:string"/>
	public Element getElement(){
		return null;
	}

}
