/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common.info;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;

import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.xml.namespace.QName;

import org.eclipse.cosmos.me.management.annotations.ManagedResource;

public class ManagedResourceInfo extends MBeanInfo {

	private ManagedAttributeInfo resourceIdAttribute = null;
	private ManagedRelationInfo[] relations;
	private ManagedNotificationConsumerInfo[] consumers;
	private String targetNamespace = "";
	private boolean hasMetrics = false;
	private boolean advertised = false;
	private boolean hasEventConsumers = false;
	private String advertisementConsumer = "";
	private Annotation[] annotations;
	private Class resourceClass;
	private String[] capabilities;
	
	ComposedCapabilityInfo [] composedCapabilities;

	private HashMap<String, String> namespaceList = new HashMap<String, String>();

	public class HandlerDescriptor {
		public HandlerDescriptor(Method method, QName inputName, QName outputName){
			this.method = method;
			this.inputName = inputName;
			this.outputName = outputName;
		}

		Method method;
		QName inputName;
		QName outputName;
	};

	private HashMap<Class, HashMap<String,HandlerDescriptor>> capabilityMethodMap = new HashMap<Class, HashMap<String,HandlerDescriptor>>();
	
	//FIXME we should proxy gets, not pass the map.
	public HashMap<Class, HashMap<String,HandlerDescriptor>> getCapabilityMethodMap(){
		return capabilityMethodMap;
	}

	public ManagedResourceInfo(Class resourceClass,
			String name, 
			String description, 
			String targetNamespace,
			String[] capabilities,
			ManagedAttributeInfo[] properties,
			MBeanConstructorInfo[] constructors, 
			ManagedOperationInfo[] operations, 
			ManagedRelationInfo[] relations, 
			ManagedNotificationInfo[] notifications, 
			ManagedNotificationConsumerInfo[] consumers, 
			ComposedCapabilityInfo[] composedCapabilities, 
			Annotation[] annotations) throws IllegalArgumentException {
		super(name, description, properties, constructors, operations, notifications);
		
		int namespaceCount = 0;
		
		this.targetNamespace = targetNamespace;
		this.annotations = annotations;
		this.resourceClass = resourceClass;
		this.capabilities = capabilities;
		namespaceList.put(targetNamespace, "dyn");
		if(properties != null){
			for(ManagedAttributeInfo property : properties){
				if(property.isResourceID() && property.isReadable() && !property.isWritable()){
					resourceIdAttribute = property;
				}else if(property.isMetric()){
					hasMetrics = true;
				}
				String namespace = property.getNamespace();
				if("".equals(namespace)){
					continue;
				}
				else{
					if(namespaceList.get(namespace) == null)
						namespaceList.put(namespace, "dyn_"+namespaceCount++);
				}
			}
		}
		if(operations != null){
			for(ManagedOperationInfo operation : operations){
				if(operation.isEventConsumer()){
					hasEventConsumers = true;
				}
				String namespace = operation.getNamespace();
				if("".equals(namespace)){
					continue;
				}
				else{
					if(namespaceList.get(namespace) == null)
						namespaceList.put(namespace, "dyn_"+namespaceCount++);
				}
			}
		}
		this.relations = relations;
		this.consumers = consumers;
		for(Annotation annotation: annotations){
			if(annotation instanceof ManagedResource){
				this.advertised = ((ManagedResource)annotation).advertise();
				this.advertisementConsumer = ((ManagedResource)annotation).advertisementConsumer();
				break;
			}
		}
		
		this.composedCapabilities = composedCapabilities;
	}
	
	public boolean hasNamespace(String namespace){
		return namespaceList.containsKey(namespace);
	}
	
	public String[] getNamespaces(){
		return namespaceList.keySet().toArray(new String[]{});
	}
	
	public String getPrefixForNamespace(String namespace){
		if("".equals(namespace)) return "dyn";
		return namespaceList.get(namespace);
	}

	public ManagedAttributeInfo getResourceIdField(){
	    return resourceIdAttribute;
	}

	public boolean resourceLifetimeSupport(){
		return false;
	}
	
	public boolean hasMetrics(){
		return hasMetrics;
	}

	public boolean isAdvertised(){
		return advertised;
	}
	
	public boolean hasEventConsumers(){
		return hasEventConsumers;
	}

	public String getAdvertisementConsumer(){
		return advertisementConsumer;
	}

	public String getTargetNamespace(){
		//TODO implement;
		return targetNamespace;
	}

	public String getResourceName(){
		//TODO implement;
		return this.getClassName();
	}

	public ManagedRelationInfo[] getRelations(){
		return relations;
	}
	
	public ManagedNotificationConsumerInfo[] getConsumers(){
		return consumers;
	}

	public ComposedCapabilityInfo[] getComposedCapabilities(){
		return composedCapabilities;
	}

    private String getMethodName(String actionName)
    {
        return Character.toLowerCase(actionName.charAt(0)) + actionName.substring(1);
    }
    
    public Class getResourceClass(){
    	return resourceClass;
    }
    
    public String[] getCapabilities(){
    	return capabilities;
    }


}
