/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.cosmos.me.management.annotations.CreateManagedRelation;
import org.eclipse.cosmos.me.management.annotations.DestroyManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;

public class ManagedProxyInvocationHandler implements InvocationHandler {

	private HashMap<Method, Annotation[]> eventMethods = new HashMap<Method, Annotation[]>();;
	private HashMap<Method, Annotation[]> getterMethods = new HashMap<Method, Annotation[]>();;
	private HashMap<Method, Annotation[]> setterMethods = new HashMap<Method, Annotation[]>();
	private HashMap<Method, Annotation[]> addMethods = new HashMap<Method, Annotation[]>();
	private HashMap<Method, Annotation[]> removeMethods = new HashMap<Method, Annotation[]>();

	private HashMap<String, Object> compositionByNamespaceMap = new HashMap<String, Object>();
	private HashMap<Class, Object> compositionByClass = new HashMap<Class, Object>();

	private HashMap<Method, Method> interceptedMethods = new HashMap<Method, Method>();

	private static ContributionManager manager;

	public static void setManager(ContributionManager mgr){
		manager = mgr;
	}

	private static final Field[] EMPTY_FIELD_ARRAY = {};

	private Object wrappedObject;

	private static Method getProxiedCapabilityByNamespaceMethod;
	private static Method getProxiedCapabilityByClassMethod;
	private static Method getProxiedClassMethod;
	private static Method getProxiedObjectMethod;
	private static Method getProxiedMethodMethod;

	private static void extractFields(Class clazz, HashMap<String, Field> map){
		Field fields[] = clazz.getDeclaredFields();
		for(Field field: fields){
			if(map.get(field.getName()) == null)
				map.put(field.getName(), field);
		}
	}

	static {
		try {
			getProxiedCapabilityByNamespaceMethod = ManagementProxy.class.getMethod("getCapability", new Class[] {String.class});
			getProxiedCapabilityByClassMethod = ManagementProxy.class.getMethod("getCapability", new Class[] {Class.class});
			getProxiedClassMethod = ManagementProxy.class.getMethod("getProxiedClass", new Class[] {});
			getProxiedObjectMethod = ManagementProxy.class.getMethod("getProxiedObject", new Class[] {});
			getProxiedMethodMethod = ManagementProxy.class.getMethod("getProxiedMethod", new Class[] {Method.class});
		} catch (SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private boolean equivelentMethod(Method iMethod, Method mMethod){
		boolean ok = true;
		if(!iMethod.getName().equals(mMethod.getName())) return false;
		if(iMethod.getReturnType().equals(mMethod.getReturnType())){
			Class[] iParms = iMethod.getParameterTypes();
			Class[] mParms = mMethod.getParameterTypes();
			if(iParms.length == mParms.length){
				int i = 0;
				for(Class pClass :iParms){
					if(pClass.equals(mParms[i++]))continue;
					ok = false;
					break;
				}
			}
		}
		return ok;
	}

	private void getDuplicateMethods(){
		Class[] interfaces = this.wrappedObject.getClass().getInterfaces();
		//test names and parm types
		HashMap<Method,Method> matchedMethod = new HashMap<Method,Method>();
		HashMap<String,ArrayList<Method>> interfaceMethods = new HashMap<String,ArrayList<Method>>();

		for(Class interfaze: interfaces){
			Method[] methods = interfaze.getMethods();
			for(Method method: methods){
				ArrayList methodList = null;
				if((methodList = interfaceMethods.get(method.getName())) == null){
					methodList = new ArrayList<Method>();
					interfaceMethods.put(method.getName(), methodList);
				}
				methodList.add(method);
			}
		}
		HashMap<Method,Method> dupMethods = new HashMap<Method,Method>();

		//TODO refactor into utility method.
		for(Method method: this.addMethods.keySet()){
			ArrayList<Method> methodList = null;
			if((methodList = interfaceMethods.get(method.getName())) != null){
				for(Method iMethod: methodList){
					if(equivelentMethod(iMethod, method)){
						dupMethods.put(iMethod,method);
					}
				}
			}
		}
		if(!dupMethods.isEmpty()){
			for(Method iMethod: dupMethods.keySet()){
				this.addMethods.put(iMethod, this.addMethods.get(dupMethods.get(iMethod)));
				this.interceptedMethods.put(iMethod, iMethod);
			}
		}
		//
		dupMethods.clear();
		for(Method method: this.removeMethods.keySet()){
			ArrayList<Method> methodList = null;
			if((methodList = interfaceMethods.get(method.getName())) != null){
				for(Method iMethod: methodList){
					if(equivelentMethod(iMethod, method)){
						dupMethods.put(iMethod,method);
					}
				}
			}
		}
		if(!dupMethods.isEmpty()){
			for(Method iMethod: dupMethods.keySet()){
				this.removeMethods.put(iMethod, this.removeMethods.get(dupMethods.get(iMethod)));
				this.interceptedMethods.put(iMethod, iMethod);
			}
		}

		//
		dupMethods.clear();
		for(Method method: this.getterMethods.keySet()){
			ArrayList<Method> methodList = null;
			if((methodList = interfaceMethods.get(method.getName())) != null){
				for(Method iMethod: methodList){
					if(equivelentMethod(iMethod, method)){
						dupMethods.put(iMethod,method);
					}
				}
			}
		}
		if(!dupMethods.isEmpty()){
			for(Method iMethod: dupMethods.keySet()){
				this.getterMethods.put(iMethod, this.getterMethods.get(dupMethods.get(iMethod)));
				this.interceptedMethods.put(iMethod, iMethod);
			}
		}
		//
		dupMethods.clear();
		for(Method method: this.setterMethods.keySet()){
			ArrayList<Method> methodList = null;
			if((methodList = interfaceMethods.get(method.getName())) != null){
				for(Method iMethod: methodList){
					if(equivelentMethod(iMethod, method)){
						dupMethods.put(iMethod,method);
					}
				}
			}
		}
		if(!dupMethods.isEmpty()){
			for(Method iMethod: dupMethods.keySet()){
				this.setterMethods.put(iMethod, this.setterMethods.get(dupMethods.get(iMethod)));
				this.interceptedMethods.put(iMethod, iMethod);
			}
		}
		//
		dupMethods.clear();
		for(Method method: this.eventMethods.keySet()){
			ArrayList<Method> methodList = null;
			if((methodList = interfaceMethods.get(method.getName())) != null){
				for(Method iMethod: methodList){
					if(equivelentMethod(iMethod, method)){
						dupMethods.put(iMethod,method);
					}
				}
			}
		}
		if(!dupMethods.isEmpty()){
			for(Method iMethod: dupMethods.keySet()){
				this.eventMethods.put(iMethod, this.eventMethods.get(dupMethods.get(iMethod)));
				this.interceptedMethods.put(iMethod, iMethod);
			}
		}
	}

	private static Method[] getBeanMethods(ManagedProperty prop, Field field, Class resourceClass){
		String name = field.getName();
		if(name.length() == 1) name = name.toUpperCase();
		else name = name.substring(0,1).toUpperCase() + name.substring(1, name.length());
		String getterName = "get" + name;
		String setterName = "set" + name;

		Class[] setterParm = {field.getType()};
		Class[] getterParm = {};
		Method getterMethod = null;
		Method setterMethod = null;
		try {
			getterMethod = resourceClass.getMethod(getterName, getterParm);
			//TODO Too stringent???
			if(!getterMethod.getReturnType().equals(field.getType())){
				getterMethod = null;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
				getterName = "is" + name;
				try {
					getterMethod = resourceClass.getMethod(getterName, getterParm);
					//TODO Too stringent???
					if(!getterMethod.getReturnType().equals(field.getType())){
						getterMethod = null;
					}
				} catch (SecurityException e1) {
					e.printStackTrace();
				} catch (NoSuchMethodException e1) {
				}
		}

		try {
			setterMethod = resourceClass.getMethod(setterName, setterParm);
			//TODO Too stringent???
			if(!setterMethod.getReturnType().equals(void.class)){
				setterMethod = null;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		}
		return new Method[]{getterMethod, setterMethod};
	}

	private static Method[] getRelationMethods(ManagedRelation relation, Field field, Class resourceClass){
		String name = field.getName();
		String addName = relation.addName();
		String removeName = relation.removeName();
		if("".equals(addName) || "".equals(removeName)){
			if("".equals(relation.name())){
				name = field.getName();
			} else {
				name = relation.name();
			}
			if(name.length() == 1) name = name.toUpperCase();
			else name = name.substring(0,1).toUpperCase() + name.substring(1, name.length());

			if("".equals(addName))addName = "add" + name;
			if("".equals(removeName))removeName = "remove" + name;
		}
		Class parmType = field.getType();
		if(!"".equals(relation.relatedClassName())){
			try {
				parmType = resourceClass.getClassLoader().loadClass(relation.relatedClassName());
			} catch (ClassNotFoundException e) {
				//FIXME bail here?
			}
		}
		Class[] addParm = {parmType};
		Class[] removeParm = {parmType};
		Method addMethod = null;
		Method removeMethod = null;
		try {
			addMethod = resourceClass.getMethod(addName, addParm);
			//TODO Too stringent???
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		}

		try {
			removeMethod = resourceClass.getMethod(removeName, removeParm);
			//TODO Too stringent???
			if(!removeMethod.getReturnType().equals(void.class)){
				removeMethod = null;
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		}
		return new Method[]{addMethod, removeMethod};
	}

	private void processAnnotations(){
		Class resourceClass = wrappedObject.getClass();
		HashMap<String,Field> map = new HashMap<String,Field>();
		Class workingClass = resourceClass;
		while(workingClass != java.lang.Object.class){
			extractFields(workingClass,map);
			workingClass = workingClass.getSuperclass();
		}
		Field fields[] = map.values().toArray(EMPTY_FIELD_ARRAY);
		for(Field field: fields){
			ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
			ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
			ManagedEvent event_annotation = field.getAnnotation(ManagedEvent.class);
			if(relation_annotation != null){
				//check for standard relationship setters (add and remove)
				Method relationMethods[] = getRelationMethods(relation_annotation, field, resourceClass);
				if(relationMethods[0] != null && relationMethods[1] != null){
					Annotation[] annotations = field.getAnnotations();
					this.addMethods.put(relationMethods[0], annotations);
					this.removeMethods.put(relationMethods[1], annotations);
					this.interceptedMethods.put(relationMethods[0], relationMethods[0]);
					this.interceptedMethods.put(relationMethods[1], relationMethods[1]);
					if(event_annotation != null){
						this.eventMethods.put(relationMethods[0], annotations);
						this.eventMethods.put(relationMethods[1], annotations);
					}
				}
			} else if(property_annotation != null && event_annotation != null){
				//check for standard bean methods (get and set)
				Method beanMethods[] = getBeanMethods(property_annotation, field, resourceClass);
				Annotation[] annotations = field.getAnnotations();
				if(event_annotation != null){
					if(beanMethods[0] != null && beanMethods[1] != null){
						this.getterMethods.put(beanMethods[0], annotations);
						this.setterMethods.put(beanMethods[1], annotations);
						this.interceptedMethods.put(beanMethods[0], beanMethods[0]);
						this.interceptedMethods.put(beanMethods[1], beanMethods[1]);
					}
				}
			}
		}
		Method methods[] = resourceClass.getMethods();

		//Make sure that for any relation stuff that both an add and remove are available for the field
		//in question.
		for(Method method: methods){
			CreateManagedRelation create_relation_annotation = getAnnotation(method, CreateManagedRelation.class);
			DestroyManagedRelation destroy_relation_annotation = getAnnotation(method, DestroyManagedRelation.class);
			ManagedEvent event_annotation = getAnnotation(method, ManagedEvent.class);
			if(create_relation_annotation != null){
				//TODO finish this
				this.addMethods.put(method, getAnnotations(method));
				this.interceptedMethods.put(method, method);
			} else if(destroy_relation_annotation != null){
				//TODO finish this
				this.removeMethods.put(method, getAnnotations(method));
				this.interceptedMethods.put(method, method);
			}
			if(event_annotation != null){
				this.interceptedMethods.put(method, method);
				this.eventMethods.put(method, getAnnotations(method));
			}
		}

		this.getDuplicateMethods();
	}

	public <A extends Annotation> A getAnnotation(Method method, Class<A> target){

		if(method.getAnnotation(target) != null){
			System.out.println("Target has annotation " + target.getName() + " method " + method.getName());
			return method.getAnnotation(target);
		}
		Class[] interfaces = this.wrappedObject.getClass().getInterfaces();
		for(Class interfaze: interfaces){
			Method[] methods = interfaze.getMethods();
			for(Method imethod: methods){
				if(equivelentMethod(imethod, method)){
					if(imethod.getAnnotation(target)!= null){
						return imethod.getAnnotation(target);
					}
				}
			}
		}
		return null;
	}

	public Annotation[] getAnnotations(Method method){

		Annotation[] annotations = method.getAnnotations();

		HashMap<Class, Annotation> map = new HashMap<Class, Annotation>();
		for(Annotation annon : annotations){
			map.put(annon.getClass(), annon);
		}
		Class[] interfaces = this.wrappedObject.getClass().getInterfaces();
		for(Class interfaze: interfaces){
			Method[] methods = interfaze.getMethods();
			String defaultNamespace = null;
			ManagedResourceCapability cap = (ManagedResourceCapability)interfaze.getAnnotation(ManagedResourceCapability.class);
			if(cap != null){
				defaultNamespace = cap.namespace();
			}
			for(Method imethod: methods){
				if(equivelentMethod(imethod, method)){
					Annotation[] iannotations = imethod.getAnnotations();
					for(Annotation annon : iannotations){
						if(map.get(annon.getClass())== null){
							map.put(annon.getClass(), annon);
							Class type = annon.annotationType();
							if(type.equals(ManagedEvent.class)){
								String namespace = ((ManagedEvent)annon).namespace();
								if("".equals(namespace)){
									Class clzz = cap.getClass();
									map.put(cap.getClass(), cap);
								}
							}
						}
					}
				}
			}
		}
		return map.values().toArray(new Annotation[]{});
	}

	public ManagedProxyInvocationHandler(Object wrappedObject){
		if(wrappedObject == null){
			throw new RuntimeException("Invalid Proxy Object Target");
		}
		this.wrappedObject = wrappedObject;
		processAnnotations();
	}

	public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
		if(method.equals(getProxiedClassMethod)) return wrappedObject.getClass();
		else if(method.equals(getProxiedObjectMethod)) return wrappedObject;
		else if(method.equals(getProxiedMethodMethod)){
			Method ret = interceptedMethods.get((Method)args[0]);
			if (ret == null) return args[0];
		}
		else if(method.equals(getProxiedCapabilityByNamespaceMethod)) return getProxyForCapability((String)args[0]);
		else if(method.equals(getProxiedCapabilityByClassMethod)) return getProxyForCapability((Class)args[0]);
		//check if this is an intercepted method
		boolean wrapMethod = false;
		boolean isAdd = false;
		boolean isRemove = false;
		boolean isSet = false;
		boolean isEvent = false;
		boolean success = false;
		Object ret = null;
		if(this.interceptedMethods.get(method) != null){
			wrapMethod = true;
			if(this.addMethods.get(method) != null){
				isAdd = true;
			} else if(this.removeMethods.get(method) != null){
				isRemove = true;
			} else if(this.setterMethods.get(method) != null){
				isSet = true;
			}
			if(this.eventMethods.get(method) != null){
				isEvent = true;
			}
		}
		if(wrapMethod){
			try{
				if(isSet && isEvent){
					preProcessAttributeChange(obj, method, args);
				}
				ret = method.invoke(wrappedObject, args);
				success = true;
				return ret;
			} finally {
				if(success){
					//Notify the bindings...
					System.out.println("Some kind of event or relationship processing goes here");
					if(isAdd){
						postProcessAdd(obj, method, args);
					} else if(isRemove){
						postProcessRemove(obj, method, args);
					} else if(isSet){
						postProcessAttributeChange(obj, method, args);
					}
					if(isEvent){
						raiseEvent(obj, method, args, ret);
					}
				}
			}

		}
		else return method.invoke(wrappedObject, args);
	}

	private void postProcessAdd(Object obj, Method method, Object[] args){
		Annotation[] annotations = addMethods.get(method);
		manager.addRelationship(obj, method, args, annotations);
	}

	private void postProcessRemove(Object obj, Method method, Object[] args){
		Annotation[] annotations = removeMethods.get(method);
		manager.removeRelationship(obj, method, args, annotations);
	}

	private void preProcessAttributeChange(Object obj, Method method, Object[] args){
		//get the previous value of the attribute... may want to event on before and after
	}

	private void postProcessAttributeChange(Object obj, Method method, Object[] args){
		//get the current value of the attribute... for event on after
	}

	private void raiseEvent(Object obj, Method method, Object[] args, Object ret){
		//need to seperate attribute change events from 'regular' events
		Annotation[] annotations = eventMethods.get(method);
		manager.raiseEvent(wrappedObject, method, args, ret, annotations);
	}

	protected void finalize() throws Throwable{
		super.finalize();
		//tell the bindings this thing is gone...
	}

	private Object getProxyForCapability(String capability){
		return compositionByNamespaceMap.get(capability);
	}

	private Object getProxyForCapability(Class capability){
		return compositionByClass.get(capability);
	}

	//package protected
	void computeProxiedMethodMap(Object proxyObject){
		Class proxyClass = proxyObject.getClass();
		if(!ManagementProxy.class.isAssignableFrom(proxyClass))return;
		for(Method interceptedMethod : this.interceptedMethods.keySet()){
			try {
				Method proxyMethod = proxyClass.getMethod(interceptedMethod.getName(), interceptedMethod.getParameterTypes());
				interceptedMethods.put(interceptedMethod, proxyMethod);
			} catch (SecurityException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	public void addProxyForComposition(ComposedCapabilityInfo composed,
			ManagementProxy composedProxy) {
		compositionByNamespaceMap.put(composed.getNamespace(), composedProxy);
		compositionByClass.put(composed.getImplClass(), composedProxy);
	}


}
