/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;

import org.eclipse.cosmos.me.management.annotations.ManagedEvent;
import org.eclipse.cosmos.me.management.annotations.ManagedOperation;
import org.eclipse.cosmos.me.management.annotations.ManagedProperty;
import org.eclipse.cosmos.me.management.annotations.ManagedRelation;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceCapability;
import org.eclipse.cosmos.me.management.annotations.ManagedResourceFactory;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.info.ComposedCapabilityInfo;
import org.eclipse.cosmos.me.management.common.util.ManagedProxyInvocationHandler;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxy;

public class ManagementProxyFactory {
	
	private static final Field[] EMPTY_FIELD_ARRAY = {};	
	private static final Class[] EMPTY_CLASS_ARRAY = {};	
	
	private static void extractFields(Class clazz, HashMap<String, Field> map){
		Field fields[] = clazz.getDeclaredFields();
		for(Field field: fields){
			if(map.get(field.getName()) == null)
				map.put(field.getName(), field);
		}
	}
	
	private static void extractInterfaces(Class clazz, HashMap<Class, Class> map){
		Class interfaces[] = clazz.getInterfaces();
		for(Class interfaze: interfaces){
			if(map.get(interfaze) == null)
				map.put(interfaze, interfaze);
		}
	}
	
	private static void processSimpleRelationship(){
		
	}
	
	private static void processNotificationRelationship(){
		
	}
	
	private static void processPropertyChangeNotification(){
		
	}
	
	private static void processOperationNotification(){
		
	}
	
	
	private static ManagedProxyInvocationHandler createHandler(Class resourceClass){
		HashMap<String,Field> map = new HashMap<String,Field>();
		Class workingClass = resourceClass;
		while(workingClass != java.lang.Object.class){
			extractFields(workingClass,map);
			workingClass = workingClass.getSuperclass();
		}
		Field fields[] = map.values().toArray(EMPTY_FIELD_ARRAY);
		resourceClass.getSuperclass();
		for(Field field: fields){
			ManagedProperty property_annotation = field.getAnnotation(ManagedProperty.class);
			ManagedRelation relation_annotation = field.getAnnotation(ManagedRelation.class);
			ManagedEvent event_annotation = field.getAnnotation(ManagedEvent.class);
			if(relation_annotation != null && event_annotation == null){
				//process as simple relationship
			} else if(relation_annotation != null && event_annotation != null){
				//process as relationship with notification
			} else if(property_annotation != null && event_annotation != null){
				//process as property change event
			}
		}
		
		Method methods[] = resourceClass.getMethods();
		for(Method method: methods){
			ManagedOperation operation_annotation = method.getAnnotation(ManagedOperation.class);
			ManagedEvent event_annotation = method.getAnnotation(ManagedEvent.class);
			if(operation_annotation != null && event_annotation != null){
				//process as event notification operation
			}
		}
		return null;
	}
	
	public static Object getManagedProxy(Object obj, ManagedResourceInfo info){
		//get the fields, checking for attribute notifications
		//get the operations, checking for invocation notifications
		//newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h)
		Class objClass = obj.getClass();

		HashMap<Class,Class> map = new HashMap<Class,Class>();
		HashMap<String, Object> capImplMap = new HashMap<String, Object>();
		

		Class workingClass = objClass;
		while(workingClass != java.lang.Object.class){
			extractInterfaces(workingClass,map);
			workingClass = workingClass.getSuperclass();
		}
				
		ComposedCapabilityInfo composedCapabilities[] = info.getComposedCapabilities();

		if(!map.isEmpty() || composedCapabilities.length > 0){
			map.put(ManagementProxy.class, ManagementProxy.class);
		}

		Class interfaces[] = map.values().toArray(EMPTY_CLASS_ARRAY);

		if(interfaces.length == 0 && composedCapabilities.length == 0){
			BindingStructureHelper.processAutowire(info, obj, capImplMap);
			return obj;
		}
		else {
			ManagedProxyInvocationHandler handler = new ManagedProxyInvocationHandler(obj);
			Object proxy = Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, handler);
			handler.computeProxiedMethodMap(proxy);
			
			for(ComposedCapabilityInfo composed : composedCapabilities){
				map.clear();
				map.put(ManagementProxy.class, ManagementProxy.class);
				workingClass = composed.getImplClass(); 
				while(workingClass != null && workingClass != java.lang.Object.class){
					extractInterfaces(workingClass,map);
					workingClass = workingClass.getSuperclass();
				}
				
				interfaces = map.values().toArray(EMPTY_CLASS_ARRAY);
				
				Class target = composed.getImplClass();
				//Make the composition implementation
				ManagedResourceCapability cap = (ManagedResourceCapability)BindingUtil.getAnnotation(ManagedResourceCapability.class, target);
				//Determine construction mechanism for composition targets
				ManagedResourceFactory factory = (ManagedResourceFactory)BindingUtil.getAnnotation(ManagedResourceFactory.class, target);
				Object capImpl = null;
				
				if(factory != null){
					//Use the factory
					System.out.println("Using factory");
				}else if(target.isInterface() && BindingStructureHelper.getCapabilityFactory(cap.namespace()) != null){
					System.out.println("Using default factory");
					Class targetFactory  = BindingStructureHelper.getCapabilityFactory(cap.namespace());
					if(targetFactory != null){
						try {
							Method factoryMethod = targetFactory.getMethod("create", new Class[]{});
							if(factoryMethod != null){
								System.out.println(Modifier.isStatic(factoryMethod.getModifiers()));
								System.out.println(factoryMethod.isAccessible());
								capImpl = factoryMethod.invoke(null, new Object[]{});
							}
						}catch(Throwable t){
							try {
								capImpl = targetFactory.newInstance();
							} catch (InstantiationException e) {
								e.printStackTrace();
								throw new RuntimeException("Failed to create Capability instance from factory " + cap.namespace() + " Class:" + target.getName());
							} catch (IllegalAccessException e) {
								e.printStackTrace();
								throw new RuntimeException("Failed to create Capability instance from factory " + cap.namespace() + " Class:" + target.getName());
							}
						}
					}
				}else {
					try{
						capImpl = target.newInstance();
					}catch(Throwable t){
						t.printStackTrace();
						throw new RuntimeException("Failed to create Capability instance for " + cap.namespace() + " Class:" + target.getName());
					}
				}
				
				capImplMap.put(composed.getNamespace(), capImpl);
				
				ManagedProxyInvocationHandler composedHandler = new ManagedProxyInvocationHandler(capImpl);
				Object composedProxy = Proxy.newProxyInstance(composed.getImplClass().getClassLoader(), interfaces, composedHandler);
				composedHandler.computeProxiedMethodMap(composedProxy);
				
				handler.addProxyForComposition(composed, (ManagementProxy)composedProxy);
				
			}
			
			BindingStructureHelper.processAutowire(info, proxy, capImplMap);
			return proxy;
		}
	}

}
