/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.osgi;

import java.util.Collection;
import java.util.HashMap;

import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingProvider;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.util.ManagedProxyInvocationHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class Activator implements BundleActivator, ServiceListener, BindingProvider {

	private BundleContext context;
	private HashMap bindings = new HashMap();
	private static final String BINDING_FILTER = "(objectclass=org.eclipse.cosmos.me.management.binding.Binding)";
	private ContributionManager osgiContributionManager = ContributionManagerImpl.getDefault();

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		this.context = context;
		osgiContributionManager.initialize(this);
		ManagedProxyInvocationHandler.setManager(osgiContributionManager);
		context.addServiceListener(this, BINDING_FILTER);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

	public void serviceChanged(ServiceEvent event) {
		ServiceReference ref = null;
		switch(event.getType()){
		case ServiceEvent.MODIFIED:
			break;
		case ServiceEvent.REGISTERED:
			ref = event.getServiceReference();
			Binding binding = (Binding)context.getService(ref);
			binding.setContributionManager(osgiContributionManager);
			bindings.put(ref, binding);
			osgiContributionManager.addAutowireTarget(binding.getBindingName(), binding);
			break;
		case ServiceEvent.UNREGISTERING:
			bindings.remove(ref);
			break;
		}

	}

	public Collection getBindings() {
		return bindings.values();
	}

}
