/*******************************************************************************
 * Copyright (c) 2005, 2007 Compuware Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Compuware Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.management.osgi;

import java.util.Dictionary;
import java.util.Hashtable;

import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

public class ContributionManagerService extends ContributionManagerImpl {
	
	private BundleContext ctx;
	
	private ServiceRegistration srvRegistration;

	
	protected void activate(ComponentContext ctxt)
	{
		this.ctx = ctxt.getBundleContext();
		start(ctx);
	}
	
	protected void deactivate(ComponentContext ctxt)
	{
		BundleContext context = ctxt.getBundleContext();
		stop(context);
	}
	
	/**
	 * Start handling events.
	 * 
	 * This method should be called by the plugin/bundle's Activator when
	 * it is started.
	 * 
	 * @param ctxBundle bundle context
	 */
	private void start(BundleContext ctxBundle ) {
	}

	/**
	 * Stop handling events 
	 *
	 * This method should be called by the plugin/bundle's Activator when
	 * it is stopped.
	 * 
	 * @param ctxBundle bundle context
	 */
	private void stop(BundleContext ctxBundle) {
	}

}
