/*
* Copyright (c) 2005-2007 Compuware Corporation and others.
* All rights reserved. This program and the accompanying
* materials are made available under the terms of the
* Eclipse Public License v1.0 which accompanies this
* distribution, and is available at:
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     Compuware Corporation - initial API and implementation
*
*/
package org.eclipse.cosmos.me.management.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.WeakHashMap;

import org.eclipse.cosmos.me.management.annotations.ManagedResource;
import org.eclipse.cosmos.me.management.binding.Binding;
import org.eclipse.cosmos.me.management.common.BindingProvider;
import org.eclipse.cosmos.me.management.common.BindingStructureHelper;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.eclipse.cosmos.me.management.common.info.ManagedResourceInfo;
import org.eclipse.cosmos.me.management.common.util.ManagementProxyFactory;

public class ContributionManagerImpl implements ContributionManager {
	
	private static BindingProvider bindingProvider;

	private static ContributionManagerImpl _default = new ContributionManagerImpl();
	
	public static ContributionManagerImpl getDefault(){
		return _default;
	}
	protected ContributionManagerImpl(){
		BindingStructureHelper.setContributionManager(this);
	}
			
	
	public void initialize(BindingProvider bindingProvider){
		this.bindingProvider = bindingProvider;
		for(Binding binding : bindingProvider.getBindings()){
			binding.setContributionManager(this);
			autowireMap.put(binding.getBindingName(),binding);
		}
	}
		
	//TODO provisional support based on annotations
	private static WeakHashMap<Object, Object> managedMap = new WeakHashMap<Object, Object>();
	private static WeakHashMap<String, Object> autowireMap = new WeakHashMap<String, Object>();
	
	public Object manage(Class clazz) {
		//Check for annotated factory method 
		//  (must be static - no args or matching the RMD info)
		return null;
	}

	public Object manage(Object object) throws Exception {
		//TODO just enough to get events working...
		if(object == null){
			System.out.println("NULL!");
		}
		Object managedObject = managedMap.get(object);
		if(managedObject != null) return managedObject;
		boolean register = false;
		ManagedResourceInfo info = BindingStructureHelper.getResourceInfo(object);
		if(info == null){
			info = new BindingStructureHelper().register(object);
			register = true;
		}
		Object proxyObject = ManagementProxyFactory.getManagedProxy(object, info);
		//FIXME deal with autowire
		//BindingStructureHelper.processAutowire(autowire, field, resourceClass, resource, composedInfoList);
		//bind this object
		if(bindingProvider != null){
			Iterator j = bindingProvider.getBindings().iterator();
			while(j.hasNext()){
				Binding binding = (Binding)j.next();
				binding.bindContribution(proxyObject, register);
			}
		}
		managedMap.put(object, proxyObject);
		ManagedResource resourceAnnotation = object.getClass().getAnnotation(ManagedResource.class);
		if(resourceAnnotation != null && !"".equals(resourceAnnotation.autowireName())){
			autowireMap.put(resourceAnnotation.autowireName(), object);
		}
		return proxyObject;
	}
	
	public void addRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)j.next();
			binding.addRelationship(object, method, args, annotations);
		}
	}
	
	public void removeRelationship(Object object, Method method, Object[] args, Annotation[] annotations) {
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)j.next();
			binding.removeRelationship(object, method, args, annotations);
		}
	}

	public void raiseEvent(Object object, Method method, Object[] args, Object ret, Annotation[] annotations) {
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)j.next();
			binding.raiseEvent(object, method, args, ret, annotations);
		}
	}
	public void statusChanged(Object object, STATUS newStatus) {
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)j.next();
			binding.statusChanged(object, newStatus);
		}
	}
	public void remove(Object object) {
		Iterator j = bindingProvider.getBindings().iterator();
		while(j.hasNext()){
			Binding binding = (Binding)j.next();
			binding.unbindContribution(object);
		}
		this.managedMap.remove(object);
	}
	
	public Object getAutowireTarget(String name){
		return autowireMap.get(name);
	}

	public boolean addAutowireTarget(String name, Object obj){
		if(autowireMap.get(name) != null) return false;
		autowireMap.put(name, obj);
		return true;
	}
	
	public boolean registerAutowireTargetFactory(Class[] capabilties,
			Object factory) {
		// TODO Auto-generated method stub
		return false;
	}

}
