/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.query.ws;

import java.io.InputStream;
import java.io.StringReader;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.CMDBfQueryOperation;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.QueryOutputTransformer;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;

public abstract class AbstractQueryService {
	protected CMDBfQueryOperation queryOp = new CMDBfQueryOperation(getQueryHandlerFactory(), null);
	
	abstract protected IQueryHandlerFactory getQueryHandlerFactory();
	
	protected CMDBfQueryOperation getQueryOperation() {
		return queryOp;
	}

	public org.apache.axiom.om.OMElement GraphQuery(
			org.apache.axiom.om.OMElement query) throws CMDBfServiceException {
		
		query.build();
		query.detach();
		
		OMElement documentElement = null;
		IQueryResult result = null;
		try {
			result = queryOp.execute(new StringReader(query.toString()));
		} catch (CMDBfServiceException e) {
			// TODO: Log
			e.printStackTrace();
			throw e;
		}
		
		InputStream output = QueryOutputTransformer.transform(result);
		XMLStreamReader parser = null;
		try {
			parser = XMLInputFactory.newInstance().createXMLStreamReader(output);
		} catch (XMLStreamException e) {
			// TODO: handle exception
		}
		//create the builder
		StAXOMBuilder builder = new StAXOMBuilder(parser);
		//get the root element
		documentElement =  builder.getDocumentElement();
		return documentElement;
	}
	
}