/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.client;

import java.util.ArrayList;
import java.util.List;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.dc.broker.ws.datamodel.BrokerConstants;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Service;

public class BrokerClient {
	private EndpointReference epr;
	private ServiceClient sender;

	public BrokerClient(String eprstr) throws AxisFault {
		this.epr = new EndpointReference(eprstr);
        Options options = new Options();
        options.setTo(epr);
        options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
        sender = new ServiceClient();
        sender.setOptions(options);
	}
	
	public OMElement registerGroup(Group group) throws AxisFault {
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        OMElement registerGroupRequest = fac.createOMElement("registerGroup", omNs);
        registerGroupRequest.addChild(group.toOM());

		OMElement result = sender.sendReceive(registerGroupRequest);

		return result;
	}
	
	public OMElement deregisterGroup(String hostname, String groupName) throws AxisFault {
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("deregisterGroup", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, deregisterGroupRequest);
        OMElement groupNamexml = fac.createOMElement("name", omNs, deregisterGroupRequest);
        fac.createOMText(hostxml, hostname);
        fac.createOMText(groupNamexml, groupName);
        
        OMElement result = sender.sendReceive(deregisterGroupRequest);
		
        return result;
	}
	
	public List<DataManager> getDataManagers() throws AxisFault {
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        // TODO: call getDataManager 
        OMElement deregisterGroupRequest = fac.createOMElement("getAllGroups", omNs);

        OMElement result = sender.sendReceive(deregisterGroupRequest);
        Groups groups = Groups.getGroups(result);
        
        List<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
        	DataManager dm = new DataManager(group);
       		dataManagers.add(dm);
        }
        return dataManagers;
	}
	
	public DataManager getDataManager(String hostname, String groupName) throws AxisFault {
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("getGroup", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, deregisterGroupRequest);
        OMElement groupNamexml = fac.createOMElement("name", omNs, deregisterGroupRequest);
        fac.createOMText(hostxml, hostname);
        fac.createOMText(groupNamexml, groupName);
        
        OMElement result = sender.sendReceive(deregisterGroupRequest);
		
        if (result != null) {
        	return new DataManager(Group.getGroup(result));
        }
        
        return null;
	}
	
	public List<DataManager> getDataManagerByNamespace(String ns) throws AxisFault {
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");
        OMElement getDataManagerByNamespaceRequest = fac.createOMElement("getGroupsByNamespace", omNs);
        OMElement hostxml = fac.createOMElement("namespace", omNs, getDataManagerByNamespaceRequest);
        fac.createOMText(hostxml, ns);
        
        OMElement result = sender.sendReceive(getDataManagerByNamespaceRequest);
		
        Groups groups = Groups.getGroups(result);
        
        List<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
        	DataManager dm = new DataManager(group);
       		dataManagers.add(dm);
        }
        return dataManagers;
	}
}
