/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.client;

import java.util.List;

import org.eclipse.cosmos.dc.broker.ws.datamodel.BrokerConstants;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Group;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Service;
import org.eclipse.cosmos.dc.broker.ws.datamodel.Services;
import org.eclipse.cosmos.dc.cmdbf.query.client.QueryServiceClient;

public class DataManager {
	
	private Group group;
	private boolean supportsCMDBfQuery = false;
	private String queryServiceEPR = null;
	private boolean supportsCMDBfRegistration = false;
	private String registrationServiceEPR = null;
	
	private String host;
	private String name;
	private String description;
	
	
	public DataManager(Group group) {
		this.group = group;
		host = group.getHost();
		name = group.getName();
		description = group.getDescription();
		
		Services services = group.getServices();
		if (services != null) {
			List<Service> serviceList = services.getServices();
			for (Service service : serviceList) {
				String ns = service.getNamespace();
				if (ns.equals(BrokerConstants.CMDBf_QUERY_NAMESPACE)) {
					supportsCMDBfQuery = true;
					queryServiceEPR = service.getEndpointReference();
				} else if (ns.equals(BrokerConstants.CMDBf_REGISTRATION_NAMESPACE)) {
					supportsCMDBfRegistration = true;
					registrationServiceEPR = service.getEndpointReference();
				}
			}
		}
	}


	/**
	 * @return the supportsCMDBfQuery
	 */
	public boolean isSupportsCMDBfQuery() {
		return supportsCMDBfQuery;
	}

	/**
	 * @return the supportsCMDBfRegistration
	 */
	public boolean isSupportsCMDBfRegistration() {
		return supportsCMDBfRegistration;
	}
	
	public QueryServiceClient getCMDBfQueryClient() {
		if (supportsCMDBfQuery) {
			return new QueryServiceClient(queryServiceEPR);
		}
		return null;
	}
	
//	public RegistrationServiceClient getCMDBfRegistrationClient() {
//		if (supportsCMDBfRegistration) {
//			return new RegistrationServiceClient(registrationServiceEPR);
//		}
//		return null;
//	}
	
	public String getServiceEPR(String namespace) {
		Services services = group.getServices();
		List<Service> serviceList = services.getServices();
		for (Service service : serviceList) {
			String ns = service.getNamespace();
			if (ns.equals(namespace)) {
				return service.getEndpointReference();
			}
		}
		return null;
	}
	
	public List<Service> getServices() {
		if (group.getServices() != null) {
			return group.getServices().getServices();
		}
		return null;
	}
	

	/**
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
}
