/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class Groups {
	private List<Group> groups = new ArrayList<Group>();
	
	public Groups() {
		
	}

	/**
	 * @return the group
	 */
	public List<Group> getGroups() {
		return groups;
	}

	/**
	 * @param group the group to set
	 */
	public void setGroups(List<Group> groups) {
		this.groups = groups;
	}
	
	public OMElement toOM() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");

        OMElement groupsxml = fac.createOMElement("groups", omNs);
        
        for (Group group : groups) {
        	groupsxml.addChild(group.toOM());
        }

        return groupsxml;

	}
	
	public static Groups getGroups(OMElement groupsxml) {
		Groups groups = new Groups();
		List<Group> groupList = new ArrayList<Group>();
		groups.setGroups(groupList);
		
		Iterator groupsIter = groupsxml.getChildElements();
		while (groupsIter.hasNext()) {
			OMElement elem = (OMElement) groupsIter.next();
			groupList.add(Group.getGroup(elem));
		}
		return groups;
	}
	
}
