/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.broker.ws.datamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class Services {
	private List<Service> services = new ArrayList<Service>();
	
	public Services() {
		
	}

	/**
	 * @return the services
	 */
	public List<Service> getServices() {
		return services;
	}

	/**
	 * @param services the services to set
	 */
	public void setServices(List<Service> services) {
		this.services = services;
	}

	public OMElement toOM() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(BrokerConstants.BROKER_NAMESPACE, "tns");

        OMElement servicesxml = fac.createOMElement("services", omNs);
        
        for (Service service : services) {
        	servicesxml.addChild(service.toOM());
        }

        return servicesxml;
	}
	
	public static Services getServices(OMElement servicesxml) {
		Services services = new Services();
		List<Service> serviceList =  new ArrayList<Service>();
		services.setServices(serviceList);
		
		Iterator servicesIter = servicesxml.getChildElements();
		while (servicesIter.hasNext()) {
			OMElement servicexml = (OMElement) servicesIter.next();
			serviceList.add(Service.getService(servicexml));
		}
		return services;

	}
}
