/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.dataManager.impl;

import java.io.File;
import java.net.URL;
import java.util.Properties;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.me.management.common.ContributionManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * 
 * This is the super class of the activator of all bundles that contains the data manager implementation. 
 *
 */
public abstract class AbstractDataManagerActivator implements BundleActivator, ServiceListener {

	protected static final String MGMT_SRV_FILTER = "(objectclass=org.eclipse.cosmos.me.management.binding.Binding)";
	protected BundleContext context;
	private IDataManager dataMgrImpl;
	
	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		
		dataMgrImpl = getDataManagerInstance();
		
		URL resource = context.getBundle().getResource("/META-INF/config.properties");
		Properties dmConfig = new Properties();
		dmConfig.load(resource.openStream());
		dataMgrImpl.setConfigProperties(dmConfig);
		
		String domainEprFile = (String) dmConfig.get(IDataManager.CONFIG_MGMT_DOMAIN_EPR_FILE);
        if (domainEprFile == null) {
        	// TODO: Log entry
        	System.out.println("Warning: Data manager registration cannot be completed because EPR of management domain is not set.");
        } else {
			URL domainEprURL = context.getBundle().getResource(domainEprFile);
			Document domainEprDoc = XmlUtils.createDocument(domainEprURL.openStream());
			Element eprElement = domainEprDoc.getDocumentElement();
			EndpointReference domainEpr = new EndpointReference(eprElement);
			dataMgrImpl.setManagementDomainEPR(domainEpr);
        }

		this.context = context;
		context.addServiceListener(this, MGMT_SRV_FILTER);
		ServiceReference references[] = context.getServiceReferences(null, MGMT_SRV_FILTER);
		for (int i = 0; references != null && i < references.length; i++) {
			this.serviceChanged(new ServiceEvent(ServiceEvent.REGISTERED, references[i]));
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	}

	/**
	 * Implementation of an API from ServiceListener.  
	 * It's invoked when management bundle is started.   
	 */
	public void serviceChanged(ServiceEvent event) {
		switch (event.getType()) {
		case ServiceEvent.REGISTERED:
			ServiceReference ref = context.getServiceReference("org.eclipse.cosmos.me.management.common.ContributionManager");
			if (ref != null) {
				ContributionManager manager = (ContributionManager)context.getService(ref);
				try {
					manager.manage(dataMgrImpl);
				} catch (Exception e) {
					System.out.println("Failed to register data manager with contribution manager.");
				}
					
				try {
					// Try to register data manager with broker at start up
					// Log error if unsuccessful.
					dataMgrImpl.register();
				} catch (Exception e) {
					// TODO: log
					System.out.println("Tried to register data manager with broker at startup, but registration failed.");
					e.printStackTrace();
				}
			}
			break;
		case ServiceEvent.MODIFIED:
			break;
		case ServiceEvent.UNREGISTERING:
			break;
		}
		
	}
	
	/**
	 * A factory method for returning an instance of the data manager implementation.
	 * This instance object should be annotated as a ManagedResource.   
	 * @return
	 */
	protected abstract IDataManager getDataManagerInstance();

}
