/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.dataManager.impl;

import java.net.URL;
import java.util.Properties;

import javax.servlet.ServletContextEvent;

import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.eclipse.cosmos.dc.dataManager.api.IDataManager;
import org.eclipse.cosmos.me.management.wsdm.web.WSDMServiceInitializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractDataManagerInitializer extends WSDMServiceInitializer {
	
	private IDataManager dataMgrImpl;
	private Properties dmConfig;
	
	
	public void contextInitialized(ServletContextEvent event) {
		dataMgrImpl = getDataManagerInstance();

		super.contextInitialized(event);
		
		
		try {
			URL resource = Thread.currentThread().getContextClassLoader().getResource("config.properties");
			dmConfig = new Properties();
			dmConfig.load(resource.openStream());
			dataMgrImpl.setConfigProperties(dmConfig);
			
			String domainEprFile = (String) dmConfig.get(IDataManager.CONFIG_MGMT_DOMAIN_EPR_FILE);
	        if (domainEprFile == null) {
	        	// TODO: Log entry
	        	System.out.println("Warning: Data manager registration cannot be completed because EPR of management domain is not set.");
	        } else {
				URL domainEprURL = Thread.currentThread().getContextClassLoader().getResource(domainEprFile);
				Document domainEprDoc = XmlUtils.createDocument(domainEprURL.openStream());
				Element eprElement = domainEprDoc.getDocumentElement();
				EndpointReference domainEpr = new EndpointReference(eprElement);
				dataMgrImpl.setManagementDomainEPR(domainEpr);
	        }
		} catch (Exception e) {
			System.out.println("Error occurred during initializing data manager.");
			e.printStackTrace();
		}

	}
	
	protected void managerInitialized(){
		try{
			this.getManager().manage(dataMgrImpl);
		}catch(Throwable t){
			t.printStackTrace();
		}
		
		// Try to register data manager with broker at start up
		// Log error if unsuccessful.
		String autoreg = dmConfig.getProperty("AUTO_REGISTER");
		if (autoreg != null && autoreg.equalsIgnoreCase("YES")) {
			String maxRetries = dmConfig.getProperty("MAX_RETRIES");
			int retryCount = maxRetries != null ? Integer.parseInt(maxRetries) : 5;

			String retriesInterval = dmConfig.getProperty("RETRY_INTERVAL");
			int interval = retriesInterval != null ? Integer.parseInt(retriesInterval) * 1000 : 5000;
			
			for (int i=0; i<retryCount; i++) {
				try {
					dataMgrImpl.register();
					break;
				} catch (Exception e) {
					// TODO: log
					System.out.println(dmConfig.getProperty(IDataManager.CONFIG_DATA_MANAGER_DISPLAY_NAME) + ": ");
					System.out.println("Tried to register data manager with broker, but registration failed. (attempt " + (i+1) +")");
					try {
						Thread.yield();
						Thread.sleep(interval);
					} catch (InterruptedException ie) {
						// ignore
					}
				}
			}
		}

	}
	
	/**
	 * A factory method for returning an instance of the data manager implementation.
	 * This instance object should be annotated as a ManagedResource.   
	 * @return
	 */
	protected abstract IDataManager getDataManagerInstance();

}
