/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.cmdbfservice;

import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;

/**
 * A general service handler that is independent of the type
 * of handler or service that it is associated with
 * 
 * @provisional
 * @author Ali Mehregani
 */
public interface IQueryHandler
{
	/**
	 * Initializes this handler with the data passed in
	 * 
	 * @param init The initialization data
	 * @throws InitializationException In case of any initialization error 
	 */
	public void initialize(Map<String, Object> init) throws CMDBfServiceException;
	
	
	/**
	 * Indicates whether this handler has been initialized
	 * 
	 * @return true iff this handler is initialized; false otherwise
	 */
	public boolean isInitialized();
	
	
	/**
	 * Sets the runtime options for this handler
	 * 
	 * @param options The runtime options
	 */
	public void setRuntimeOptions(Map<String, Object> options);
	
	
	/**
	 * Returns the runtime options for this handler
	 * 
	 * @return The runtime options for this handler
	 */
	public Map<String, Object> getRuntimeOptions();
	
}
