/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;

/**
 * This represents an identifier that includes a qualifier
 * indicating the associated MDR.
 * 
 * @author David Whiteman
 */
public abstract class AbstractInstanceId implements IInstanceId {
	private URI mdrId;
	private URI localId;
	
	public AbstractInstanceId() {
	}

	public AbstractInstanceId(URI mdrId, URI localId) {
		setMdrId(mdrId);
		setLocalId(localId);
	}

	public AbstractInstanceId(String mdrId, String localId) {
		setMdrId(mdrId);
		setLocalId(localId);
	}

	public void setLocalId(String localId) {
		setLocalId(CMDBfServicesUtil.createURI(localId));
	}

	public void setMdrId(String mdrId) {
		setMdrId(CMDBfServicesUtil.createURI(mdrId));
	}

	public URI getMdrId() {
		return mdrId;
	}

	public void setMdrId(URI mdrId) {
		this.mdrId = mdrId;
	}

	public URI getLocalId() {
		return localId;
	}

	public void setLocalId(URI localId) {
		this.localId = localId;
	}
	
	public void outputIdentifiers(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT));
		writer.write(CMDBfServicesUtil.toString(getMdrId()));
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.MDR_ID_ELEMENT)+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.LOCAL_ID_ELEMENT));
		writer.write(CMDBfServicesUtil.toString(getLocalId()));
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + ICMDBfServicesConstants.LOCAL_ID_ELEMENT)+ICMDBfServicesConstants.nl);
	}
	
	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getElementName())+ICMDBfServicesConstants.nl);
		
		outputIdentifiers(writer, indent+1);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getElementName())+ICMDBfServicesConstants.nl);
	}
	
	abstract protected String getElementName();

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((localId == null) ? 0 : localId.hashCode());
		result = prime * result + ((mdrId == null) ? 0 : mdrId.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AbstractInstanceId other = (AbstractInstanceId) obj;
		if (localId == null) {
			if (other.localId != null)
				return false;
		} else if (!localId.equals(other.localId))
			return false;
		if (mdrId == null) {
			if (other.mdrId != null)
				return false;
		} else if (!mdrId.equals(other.mdrId))
			return false;
		return true;
	}
}
