/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IAdditionalRecordType;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;

/**
 * Factory for creating artifacts used by various transformers in the query and
 * registration services.
 * 
 * @author David Whiteman
 */
public class CommonArtifactFactory implements ICommonArtifactFactory {

	private static ICommonArtifactFactory instance;

	public static ICommonArtifactFactory getInstance() {
		if (instance == null) {
			instance = new CommonArtifactFactory();
		}

		return instance;
	}

	/**
	 * Replace the default factory being used to create instances of
	 * artifact interfaces
	 * 
	 * @param factory
	 */
	public static void setInstance(ICommonArtifactFactory factory) {
		instance = factory;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.ICommonArtifactFactory#createAdditionalRecordType(java.lang.String, java.lang.String)
	 */
	public IAdditionalRecordType createAdditionalRecordType(String namespace,
			String localName) {
		return new AdditionalRecordType(namespace, localName);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.ICommonArtifactFactory#createInstanceId()
	 */
	public IInstanceId createInstanceId() {
		return new InstanceId();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.ICommonArtifactFactory#createInstanceId(java.lang.String, java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return new InstanceId(mdrId, localId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.ICommonArtifactFactory#createRecord(org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement, java.lang.String)
	 */
	public IRecord createRecord(IGraphElement parent, String recordId) {
		IRecord record = new Record(parent);
		IRecordMetadata recordMetadata = createRecordMetadata();
		if (recordId != null) {
			recordMetadata.setRecordId(CMDBfServicesUtil.createURI(recordId));
		}
		record.setRecordMetadata(recordMetadata);

		return record;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts.ICommonArtifactFactory#createRecordMetadata()
	 */
	public IRecordMetadata createRecordMetadata() {
		return new RecordMetadata();
	}
}
