/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.internal.transform.artifacts;

import java.io.StringWriter;
import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.cmdbf.services.internal.CMDBfInternalUtility.XMLWritableString;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordMetadata;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRecordSerializer;

/**
 * @author David Whiteman
 */
public class RecordMetadata implements IRecordMetadata {
	private URI recordId;
	private String baselineId;
	private String snapshotId;
	private String lastModified;
	private IXMLWritable extensibilityElements;

	public URI getRecordId() {
		return recordId;
	}
	
	public void setRecordId(URI recordId) {
		this.recordId = recordId;
	}

	public String getBaselineId() {
		return baselineId;
	}

	public void setBaselineId(String baselineId) {
		this.baselineId = baselineId;
	}

	public String getSnapshotId() {
		return snapshotId;
	}

	public void setSnapshotId(String snapshotId) {
		this.snapshotId = snapshotId;
	}

	public String getLastModified() {
		return lastModified;
	}

	public void setLastModified(String lastModified) {
		this.lastModified = lastModified;
	}

	public IXMLWritable getExtensibilityElements() {
		return extensibilityElements;
	}

	public void setExtensibilityElements(IXMLWritable extensibilityElements) {
		this.extensibilityElements = extensibilityElements;
	}

	public void setExtensibilityElementsFromString(String stringRepresentationOfValue) {
		IRecordSerializer serializer = CMDBfServicesUtil.getRecordSerializer();
		IXMLWritable writable = null;
		if (serializer != null) {
			writable = serializer.deserialize(stringRepresentationOfValue);
		} else {
			writable = new XMLWritableString(stringRepresentationOfValue);
		}
		setExtensibilityElements(writable);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((baselineId == null) ? 0 : baselineId.hashCode());
		result = prime
				* result
				+ ((extensibilityElements == null) ? 0 : extensibilityElements
						.hashCode());
		result = prime * result
				+ ((lastModified == null) ? 0 : lastModified.hashCode());
		result = prime * result
				+ ((recordId == null) ? 0 : recordId.hashCode());
		result = prime * result
				+ ((snapshotId == null) ? 0 : snapshotId.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final RecordMetadata other = (RecordMetadata) obj;
		if (baselineId == null) {
			if (other.baselineId != null)
				return false;
		} else if (!baselineId.equals(other.baselineId))
			return false;
		if (extensibilityElements == null) {
			if (other.extensibilityElements != null)
				return false;
		} else if (!extensibilityElements.equals(other.extensibilityElements))
			return false;
		if (lastModified == null) {
			if (other.lastModified != null)
				return false;
		} else if (!lastModified.equals(other.lastModified))
			return false;
		if (recordId == null) {
			if (other.recordId != null)
				return false;
		} else if (!recordId.equals(other.recordId))
			return false;
		if (snapshotId == null) {
			if (other.snapshotId != null)
				return false;
		} else if (!snapshotId.equals(other.snapshotId))
			return false;
		return true;
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil
				.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.RECORD_METADATA_ELEMENT)
				+ ICMDBfServicesConstants.nl);

		CMDBfServicesUtil.addIndent(writer, indent + 1);
		writer.write(CMDBfServicesUtil
				.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.RECORD_ID_ELEMENT));
		writer.write(CMDBfServicesUtil.toString(getRecordId()));
		writer.write(CMDBfServicesUtil
				.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.RECORD_ID_ELEMENT)
				+ ICMDBfServicesConstants.nl);

		if (lastModified != null) {
			CMDBfServicesUtil.addIndent(writer, indent + 1);
			writer
					.write(CMDBfServicesUtil
							.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.LAST_MODIFIED_ELEMENT));
			writer.write(getLastModified().toString());
			writer.write(CMDBfServicesUtil
					.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.LAST_MODIFIED_ELEMENT)
					+ ICMDBfServicesConstants.nl);
		}

		if (baselineId != null) {
			CMDBfServicesUtil.addIndent(writer, indent + 1);
			writer.write(CMDBfServicesUtil
					.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.BASE_LINE_ID_ELEMENT));
			writer.write(getBaselineId().toString());
			writer.write(CMDBfServicesUtil
					.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.BASE_LINE_ID_ELEMENT)
					+ ICMDBfServicesConstants.nl);
		}

		if (snapshotId != null) {
			CMDBfServicesUtil.addIndent(writer, indent + 1);
			writer.write(CMDBfServicesUtil
					.beginTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.SNAPSHOT_ID_ELEMENT));
			writer.write(getSnapshotId().toString());
			writer.write(CMDBfServicesUtil
					.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.SNAPSHOT_ID_ELEMENT)
					+ ICMDBfServicesConstants.nl);
		}

		if (extensibilityElements != null) {
			extensibilityElements.toXML(writer, indent + 1);
		}

		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil
				.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX +ICMDBfServicesConstants.RECORD_METADATA_ELEMENT)
				+ ICMDBfServicesConstants.nl);
	}

}
