/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.transform;

/**
 * Exception thrown during the parsing of XML input data that
 * might also wrap another exception with more detail.
 * 
 * @provisional
 * @author David Whiteman
 */
public class TransformerException extends Exception {

	public TransformerException() {
		super();
	}

	public TransformerException(String message, Throwable cause) {
		super(message, cause);
	}

	public TransformerException(String message) {
		super(message);
	}

	public TransformerException(Throwable e) {
		super(e);
	}

	private static final long serialVersionUID = 1L;

}
