/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.cmdbf.services.common.IXMLWritable;

/**
 * Represents an MDR scoped ID used in either <instanceId> elements or as the
 * source or target of an IRelationship.
 * 
 * @provisional
 * @author David Whiteman
 */
public interface IInstanceId extends IXMLWritable {
	/**
	 * Answer the ID of the MDR where this instance can be found
	 * 
	 * @return
	 */
	public URI getMdrId();

	/**
	 * Answer the local ID of the instance in the specified MDR
	 * 
	 * @return
	 */
	public URI getLocalId();

	/**
	 * Set the ID of the MDR where this instance can be found. The
	 * <tt>mdrId</tt> should be a String containing a valid URI.
	 * 
	 * @param mdrIdURIString
	 *            String containing a valid URI for the MDR ID
	 */
	public void setMdrId(String mdrIdURIString);

	/**
	 * Set the ID that identifies this instance locally within the MDR
	 * 
	 * @param localIdURIString
	 *            String containing a valid URI for the local ID
	 */
	public void setLocalId(String localIdURIString);
}
