/*******************************************************************************
 * Copyright (c) 2008 CA
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.logging.datamgr.ws.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.cosmos.common.exceptions.CosmosException;

public class CBEClient implements ICBEClient {
	private EndpointReference epr;
	private ServiceClient sender;
	public static final String DM_NAMESPACE = "http://axis.datamgr.logging.dc.cosmos.eclipse.org";

	public CBEClient(String eprstr) throws CosmosException {
		this.epr = new EndpointReference(eprstr);
		Init();
	}
	
	public Collection<String> getDatasets() throws CosmosException {
		Collection<String> ret = null;
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getLogFileIdentifiers", omNs);

        OMElement result = null;
        try {
        	result = sender.sendReceive(tsRequest);
        } catch (AxisFault a) {
        	throw new CosmosException(a);
        }
        Iterator Iter = result.getChildElements();
        ret = getFiles(Iter);
        return ret; 
	}

	public Collection<CommonBaseEvent> getAllCBE(String logfile) throws CosmosException
	{
		Collection<CommonBaseEvent> ret = null;
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getCBEs", omNs);

        OMElement value1 = fac.createOMElement("logfile", omNs);
        value1.addChild(fac.createOMText(value1, logfile));
        tsRequest.addChild(value1);
        
        OMElement result = null;
        
        try {
        	result = sender.sendReceive(tsRequest);
        } catch (AxisFault a) {
        	throw new CosmosException("AxisFault");
        }
        
        Iterator Iter = result.getChildElements();
        ret = DoAllCBE(Iter);
        return ret;
	}
	
	public Collection<CBESeverityCount> getCBECountBySeverity(String logfile) throws CosmosException
	{
		Collection<CommonBaseEvent> cbe = null;
		OMElement e = null;
		Iterator cbeI = null;
		CommonBaseEvent ev = null;
		String cname = null;
		CBESeverityCount sc = null;
				
		cbe = getAllCBE(logfile);
			
		HashMap<String, CBESeverityCount> componentMap = new HashMap<String, CBESeverityCount>();
		
		cbeI = cbe.iterator();
	    while (cbeI.hasNext()) {
	    	ev = (CommonBaseEvent) cbeI.next();
	    	cname = ev.getSourceComponentId().getComponent();
	    	sc = componentMap.get(cname);
	    	if (sc == null) {
	    		sc = new CBESeverityCount(cname);
	    		componentMap.put(cname,sc);
	    	}
	    	if (ev.getSeverity() >= 50) 
	    		sc.setSevereCount(sc.getSevereCount() + 1);
	    	else {
	    		if (ev.getSeverity() >= 30) 
	    			sc.setWarningCount(sc.getWarningCount() + 1);
	    		else
	    			sc.setInfoCount(sc.getInfoCount() + 1);
	    	}
	    }	

	    return componentMap.values();
	}

	private void Init() throws CosmosException 
	{
		Options options = new Options();
		options.setTo(epr);
		options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
		try {
			sender = new ServiceClient();
		} catch (AxisFault a) {
			throw new CosmosException("AxisFault");
		}
		sender.setOptions(options);
	}
	private Collection<String> getFiles(Iterator Iter) {
		ArrayList<String> ret = null;
		
		ret = new ArrayList<String>();
		Populate(Iter,ret);
		return ret;
	}
	
	private void Populate(Iterator Iter,ArrayList<String> list) {
		
		while (Iter.hasNext()) {
			OMElement elem = (OMElement) Iter.next();
			if (elem.getLocalName().equals("LogFile")) {
				String t = elem.getText();
				if ((t != null) && (t.length() > 0)) 
					list.add(t);
			}
			Iterator n = elem.getChildElements();
			if (n != null) {
				Populate(n,list);
			}
		}
	}
	private void Print(Iterator Iter) {
		
		while (Iter.hasNext()) {
			OMElement elem = (OMElement) Iter.next();
			System.out.println("Name " + elem.getLocalName());
			String t = elem.getText();
			if ((t != null) && (t.length() > 0)) 
				System.out.println("Text: " + t);
			Iterator n = elem.getChildElements();
			if (n != null) {
				Print(n);
			}
		}
	}
	private Collection<CommonBaseEvent> DoAllCBE(Iterator Iter) {
		ArrayList<CommonBaseEvent> ret = null;
				
		ret = new ArrayList<CommonBaseEvent>();
		
		lookForCBE(Iter,ret);
		return ret;
	}
	
	private void lookForCBE(Iterator Iter,Collection<CommonBaseEvent> list)
	{
		while (Iter.hasNext()) {
			OMElement elem = (OMElement) Iter.next();
			if (elem.getLocalName().equals("CommonBaseEvent")) 
				CreateCBE(Iter,list);
			Iterator n = elem.getChildElements();
			if (n != null) 
				lookForCBE(n,list);
		}
	}
	private void CreateCBE(Iterator Iter,Collection<CommonBaseEvent> list)
	{
		EventFactory eventFactory = EventFactoryImpl.getInstance(); 
		CommonBaseEvent cbe = eventFactory.createCommonBaseEvent(); 
		OMElement e = (OMElement) Iter.next();
		
		ProcessBaseAttributes(e,cbe);
		ProcessStuff(e,cbe);
		list.add(cbe);
		
	}
	private void ProcessStuff(OMElement elem,CommonBaseEvent cbe)
	{
		Iterator n = elem.getChildElements();
		while (n.hasNext()) {
			OMElement e = (OMElement) n.next();
			String l = e.getLocalName();
			if (l.equals("extendedDataElements")) 
				ProcessExtendedDataElements(e,cbe);
			if (l.equals("sourceComponentId")) 
				ProcessSourceComponentId(e,cbe);
			if (l.equals("situation"))
				ProcessSituation(e,cbe);
		}
	}
	private void ProcessExtendedDataElements(OMElement elem,CommonBaseEvent cbe) 
	{
		Iterator n = elem.getChildElements();
		OMElement e = (OMElement) n.next();
		String value = e.getText();
		String t = null;
		String name = null;
		int ivalue = 0;
		
		Iterator attrs = elem.getAllAttributes();
		while (attrs.hasNext()) {
			OMAttribute ae = (OMAttribute) attrs.next();
			if (ae.getLocalName().equals("name")) 
				name = ae.getAttributeValue();
			
			if (ae.getLocalName().equals("type"))
				t = ae.getAttributeValue();	
		}
		
		if (!t.equals("string") && !t.equals("short") && !t.equals("int"))
			System.out.println("Unknown type" + t);
		else {
			if (t.equals("short")) {
			  short svalue = Short.valueOf(value).shortValue();
			  cbe.addExtendedDataElementWithShortValue(name, svalue);
			}
			else {
				if (t.equals("int")) {
					ivalue = Integer.valueOf(value).intValue();
					cbe.addExtendedDataElementWithIntValue(name,ivalue);
				}
				else
					cbe.addExtendedDataElement(name,value);				
			}
		}
	}
		
	private void ProcessBaseAttributes(OMElement e,CommonBaseEvent cbe)
	{
		Iterator attrs = e.getAllAttributes();
		while (attrs.hasNext()) {
			OMAttribute ae = (OMAttribute) attrs.next();
			SetBase(cbe,ae);
		}
	}
		
	private void SetBase(CommonBaseEvent c,OMAttribute arg)
	{
		if (arg.getLocalName().equals("creationTime")) 
			c.setCreationTime(arg.getAttributeValue());
		
		if (arg.getLocalName().equals("globalInstanceId"))
			c.setGlobalInstanceId(arg.getAttributeValue());	
		
		if (arg.getLocalName().equals("extensionName"))
			c.setExtensionName(arg.getAttributeValue());

		if (arg.getLocalName().equals("localInstanceId"))
			c.setLocalInstanceId(arg.getAttributeValue());
		
		if (arg.getLocalName().equals("msg"))
			c.setMsg(arg.getAttributeValue());
				
		if (arg.getLocalName().equals("priority")) {
			String s = arg.getAttributeValue();
			short sh = Short.valueOf(s).shortValue();
			c.setPriority(sh);
		}	

		if (arg.getLocalName().equals("repeatCount")) {
			String s = arg.getAttributeValue();
			short sh = Short.valueOf(s).shortValue();
			c.setRepeatCount(sh);
		}
			
		if (arg.getLocalName().equals("sequenceNumber")) {
			String s = arg.getAttributeValue();
			long l = Long.valueOf(s).longValue();
			c.setSequenceNumber(l);
		}
			
		if (arg.getLocalName().equals("severity")) {
			String s = arg.getAttributeValue();
			short sh = Short.valueOf(s).shortValue();
			c.setSeverity(sh);
		}
	}
	private void ProcessSourceComponentId(OMElement e,CommonBaseEvent cbe)
	{
		String application = new String("");
		String component = new String("");
		String subComponent = new String("");
		String componentType = new String("");
		String componentIdType = new String("");
		String location = new String("");
		String locationType = new String("");
	    
		Iterator attrs = e.getAllAttributes();
		while (attrs.hasNext()) {
			OMAttribute ae = (OMAttribute) attrs.next();
						
			if (ae.getLocalName().equals("application"))
				application = ae.getAttributeValue();
	        	
			if (ae.getLocalName().equals("component"))
				component = ae.getAttributeValue();
	        	
			if (ae.getLocalName().equals("subComponent"))
				subComponent = ae.getAttributeValue();
	        
			if (ae.getLocalName().equals("componentType"))
				componentType = ae.getAttributeValue();
	        
			if (ae.getLocalName().equals("ComponentIdType"))
				componentIdType = ae.getAttributeValue();
	        
			if (ae.getLocalName().equals("location"))
				location = ae.getAttributeValue();
	        
			if (ae.getLocalName().equals("locationType"))
				locationType = ae.getAttributeValue();
	        
			cbe.setSourceComponentId(application,component,subComponent,componentType,componentIdType,location,locationType);
		}
	}
	private void ProcessSituation(OMElement e,CommonBaseEvent cbe)
	{
		EventFactory eventFactory = EventFactoryImpl.getInstance(); 
		Situation s = eventFactory.createSituation();
		Iterator n = e.getChildElements();
		
		Iterator attrs = e.getAllAttributes();
		while (attrs.hasNext()) {
			OMAttribute ae = (OMAttribute) attrs.next();
						
			if (ae.getLocalName().equals("categoryName"));
				s.setCategoryName(ae.getAttributeValue());
		}
		
		OMElement el = (OMElement) n.next();
		
		String type = SetArg(el,"type");
		String reason = SetArg(el,"reasoningScope");
		String available = SetArg(el,"availabilityDisposition");
		String operation = SetArg(el,"operationDisposition");
		String process = SetArg(el,"processingDisposition");
		String success = SetArg(el,"successDisposition");
		String situation = SetArg(el,"situationDisposition");
		String depend = SetArg(el,"dependencyDisposition");
		String feature = SetArg(el,"featureDisposition");
		String any = SetArg(el,"any");
		String rcat = SetArg(el,"ReportCategory");
		String qualifier = SetArg(el,"situationQualifier");
						
		if (type.equals("AvailableSituation")) 
			s.setAvailableSituation(reason, available,operation,process);
			
		if (type.equals("ConfigureSituation")) 
			s.setConfigureSituation(reason, success);
				
		if (type.equals("ConnectSituation")) 
			s.setConnectSituation(reason, situation,success); 
				
		if (type.equals("CreateSituation")) 
			s.setCreateSituation(reason, success); 
				
		if (type.equals("DependencySituation")) 
			s.setDependencySituation(reason, depend); 
		
		if (type.equals("DestroySituation")) 
			s.setDestroySituation(reason, success);  
		
		if (type.equals("FeatureSituation")) 
			s.setFeatureSituation(reason, feature);  
		
		if (type.equals("OtherSituation")) 
			s.setOtherSituation(reason, any);  
		
		if (type.equals("ReportSituation")) 
			s.setReportSituation(reason, rcat);  
		
		if (type.equals("RequestSituation")) 
			s.setRequestSituation(reason,qualifier,success);
		
		if (type.equals("StartSituation")) 
			s.setStartSituation(reason,qualifier,success);
		
		if (type.equals("StopSituation")) 
			s.setStopSituation(reason,qualifier,success); 
		
		cbe.setSituation(s);
	}
	
	public String SetArg(OMElement el,String arg) {
		String ret = null;
		Iterator attrs = el.getAllAttributes();
		while (attrs.hasNext()) {
			OMAttribute ae = (OMAttribute) attrs.next();
		
			if (ae.getLocalName().equals(arg))
				ret = ae.getAttributeValue();
		}
		return ret;
	}
}

class AxisTestClient {
	public static final String MY_EPR = "http://localhost:8080/org.eclipse.cosmos.dc.logging.datamgr.ws/services/CBEServices";

	private String _epr = null;
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		AxisTestClient tc = null;
		
		if (args.length == 0)
			tc = new AxisTestClient();
		else
			tc = new AxisTestClient(args[0]);
		
		tc.testLogFiles();
		tc.testCBEs();
		tc.testSev();
	}
	
	public AxisTestClient(String epr) {
		_epr = new String(epr);
	}
	
	public AxisTestClient() { 
		_epr = new String(MY_EPR); 
	}
	public void testSev()
	{
		CBEClient c = null;
		Iterator Iter = null;
		try {
			c = new CBEClient(_epr);
		} catch (Exception e) {
			System.out.println("EEK");
			e.printStackTrace();
			return;
		}

		Collection<CBESeverityCount> ret = null;
		try {
			ret = c.getCBECountBySeverity("access_log.cbe.xml");
		} catch(Exception e) {
			System.out.println("response trouble.");
			e.printStackTrace();
			return;
		}
		Iterator r = ret.iterator();
		CBESeverityCount cbe = (CBESeverityCount) r.next();
		cbe.Print();
	}
	public void testCBEs()
	{
		CBEClient c = null;
		Iterator Iter = null;
		try {
			c = new CBEClient(_epr);
		} catch (Exception e) {
			System.out.println("EEK");
			e.printStackTrace();
			return;
		}

		Collection<CommonBaseEvent> ret = null;
		try {
			ret = c.getAllCBE("access_log.cbe.xml");
		} catch(Exception e) {
			System.out.println("response trouble.");
			e.printStackTrace();
			return;
		}
		Iterator r = ret.iterator();
		CommonBaseEvent cbe = (CommonBaseEvent) r.next();
		System.out.println("CBE: " + cbe.toString());
	}
	public void testLogFiles()
	{
		CBEClient c = null;
		Iterator Iter = null;
		try {
			c = new CBEClient(_epr);
		} catch (Exception e) {
			System.out.println("EEK");
			e.printStackTrace();
			return;
		}

		Collection<String> ret = null;
		try {
			ret = c.getDatasets();
		} catch(Exception e) {
			System.out.println("response trouble.");
			e.printStackTrace();
			return;
		}
		
		Iter = ret.iterator();
		while (Iter.hasNext()) {
			String tmp = (String) Iter.next();
			System.out.println("LogFile " + tmp);
		}
	}
}